% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texture.R
\name{texture}
\alias{texture}
\alias{texture.formula}
\alias{texture.default}
\alias{print.texture}
\alias{plot.texture}
\alias{as_tridata}
\alias{as_tridata.default}
\alias{as_tridata.texture}
\title{ASTM soil texture analysis}
\usage{
texture(reading, ...)

\method{texture}{formula}(formula, data = NULL, ...)

\method{texture}{default}(
  reading,
  blank,
  time,
  temp,
  conc = 50,
  Gs = 2.65,
  hydrometer = "auto",
  model = "auto",
  plot = F,
  ...
)

\method{print}{texture}(x, ...)

\method{plot}{texture}(x, ...)

as_tridata(x, ...)

\method{as_tridata}{default}(x, ...)

\method{as_tridata}{texture}(x, which = NULL, ...)
}
\arguments{
\item{reading}{a numeric vector of data values providing the hydrometer
readings at the bottom of the meniscus.}

\item{\dots}{further arguments to be passed to \code{texture}() (currently
not used), \code{print}(), or \code{plot}().}

\item{formula}{an object of class '\code{\link[stats]{formula}}' of the form
\code{reading ~ blank + time + temp}.}

\item{data}{a data frame containing the variables in \code{formula}.}

\item{blank}{a numeric vector containing the blank readings taken in 5 g/L
sodium hexametaphosphate solution (composite correction).}

\item{time}{a numeric vector containing the time passed since the beginning
of the measurement in minutes.}

\item{temp}{an integer vector containing the measured temperature.}

\item{conc}{the concentration of the soil solution, default is 50 g/L as
proposed in the ASTM guideline.}

\item{Gs}{specific gravity of the suspension.}

\item{hydrometer}{a character string specifying the hydrometer used; accepted
values are \code{"auto"} for auto-detection (default), \code{"151H"}, and
\code{"152H"}.}

\item{model}{string is passed to \code{\link[drc]{drm}()}, "auto" chooses the
best fitting model automatically.}

\item{plot}{logical; if \code{TRUE} the particle size distribution is plotted.}

\item{x}{an object of class '\code{texture}'.}

\item{which}{character value indicating the soil texture classification
system to export; accepts \code{"din"} or \code{"usda"}.}
}
\value{
\code{texture} returns an object of \code{\link[base]{class}} '\code{texture}'.
The functions \code{print}() and \code{plot}() are available to retrieve the
soil texture classes and the particle size distribution, respectively.

An object of class '\code{texture}' is a list containing the following
components:

\describe{
  \item{\code{meta}}{Measurement meta data}
  \item{\code{distribution}}{data frame providing the particle size
  distribution}
  \item{\code{model}}{information on the fitted \code{\link[drc]{drm}} model}
  \item{\code{din}}{Main DIN texture classes}
  \item{\code{usda}}{Main USDA texture classes}
}

\code{as_tridata} converts '\code{texture}' to data.frames of a specific
structure require for \code{\link[soiltexture]{soiltexture-package}}.
}
\description{
Calculates the particle size distribution and both DIN and USDA texture
classes from a series of hydrometer readings in accordance with ASTM D422-63
(2007).
}
\examples{
data(clayloam)
texture(reading ~ blank + time + temperature, data = clayloam)

}
\references{
ASTM D422-63 (2007). \emph{Standard Test Method for Particle-Size Analysis
of Soils}. Technical standard. ASTM International, West Conshohocken, PA.
Available from \url{https://www.astm.org/standards/d422}.
}
\seealso{
Other texture: 
\code{\link{clayloam}}
}
\author{
Zacharias Steinmetz
}
\concept{texture}
