% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{svacor}
\alias{svacor}
\title{Surrogate variable analysis(SVA) to correct the unknown batch effects}
\usage{
svacor(xset, lv = NULL, method = "medret", intensity = "into")
}
\arguments{
\item{xset}{xcmsset object}

\item{lv}{group information}

\item{method}{parameter for groupval function}

\item{intensity}{parameter for groupval function}
}
\value{
list object with various components such raw data, corrected data, signal part, random errors part, batch part, p-values, q-values, mass, rt, Posterior Probabilities of Surrogate variables and Posterior Probabilities of Mod. If no surrogate variable found, corresponding part would miss.
}
\description{
Surrogate variable analysis(SVA) to correct the unknown batch effects
}
\details{
this is used for reviesed version of SVA to correct the unknown batch effects
}
\examples{
\dontrun{
library(faahKO)
cdfpath <- system.file("cdf", package = "faahKO")
cdffiles <- list.files(cdfpath, recursive = TRUE, full.names = TRUE)
xset <- xcmsSet(cdffiles)
xset <- group(xset)
xset2 <- retcor(xset, family = "symmetric", plottype = "mdevden")
xset2 <- group(xset2, bw = 10)
xset3 <- fillPeaks(xset2)
df <- svacor(xset3)
}
}
\seealso{
\code{\link{svapca}}, \code{\link{svaplot}}, \code{\link{svabatch}}
}
