% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getdata.R
\name{getdata2}
\alias{getdata2}
\title{Get XCMSnExp object in one step from structured folder path for xcms 3.}
\usage{
getdata2(
  path,
  index = F,
  snames = NULL,
  sclass = NULL,
  phenoData = NULL,
  BPPARAM = BiocParallel::SnowParam(),
  mode = "onDisk",
  ppp = xcms::CentWaveParam(ppm = 5, peakwidth = c(5, 25), prefilter = c(3, 5000)),
  rtp = xcms::ObiwarpParam(binSize = 1),
  gpp = xcms::PeakDensityParam(sampleGroups = 1, minFraction = 0.67, bw = 2, binSize =
    0.025),
  fpp = xcms::FillChromPeaksParam()
)
}
\arguments{
\item{path}{the path to your data}

\item{index}{the index of the files}

\item{snames}{sample names. By default the file name without extension is used}

\item{sclass}{sample classes.}

\item{phenoData}{data.frame or NAnnotatedDataFrame defining the sample names and classes and other sample related properties. If not provided, the argument sclass or the subdirectories in which the samples are stored will be used to specify sample grouping.}

\item{BPPARAM}{used for BiocParallel package}

\item{mode}{'inMemory' or 'onDisk' see `?MSnbase::readMSData` for details, default 'onDisk'}

\item{ppp}{parameters for peaks picking, e.g. xcms::CentWaveParam()}

\item{rtp}{parameters for retention time correction, e.g. xcms::ObiwarpParam()}

\item{gpp}{parameters for peaks grouping, e.g. xcms::PeakDensityParam()}

\item{fpp}{parameters for peaks filling, e.g. xcms::FillChromPeaksParam(), PeakGroupsParam()}
}
\value{
a XCMSnExp object with processed data
}
\description{
Get XCMSnExp object in one step from structured folder path for xcms 3.
}
\details{
This is a wrap function for metabolomics data process for xcms 3.
}
\seealso{
\code{\link{getdata}},\code{\link{getmzrt}}
}
