% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sccp.R
\name{getsccp}
\alias{getsccp}
\title{Quantitative analysis for short-chain chlorinated paraffins(SCCPs)}
\usage{
getsccp(
  pathstds,
  pathsample,
  ismz = 323,
  ppm = 5,
  con = 2000,
  rt = NULL,
  rts = NULL,
  log = TRUE
)
}
\arguments{
\item{pathstds}{mzxml file path for SCCPs standards}

\item{pathsample}{mzxml file path for samples}

\item{ismz}{internal standards m/z}

\item{ppm}{resolution of mass spectrum}

\item{con}{concentration of standards}

\item{rt}{retention time range of sccps}

\item{rts}{retention time range of internal standards}

\item{log}{log transformation for response factor}
}
\value{
list with peak information
}
\description{
Quantitative analysis for short-chain chlorinated paraffins(SCCPs)
}
\seealso{
\code{\link{getareastd}},\code{\link{getarea}}
}
