% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/petExtremes.R
\name{petExtremes}
\alias{petExtremes}
\title{PET Extremes}
\usage{
petExtremes(PETstack, precipStack, meantempStack)
}
\arguments{
\item{PETstack}{rasterStack of monthly PET}

\item{precipStack}{rasterStack of monthly precipitation}

\item{meantempStack}{rasterStack of monthly mean temperature}
}
\value{
rasterStack of PETColdestQuarter, PETWarmestQuarter, PETWettestQuarter, PETDriestQuarter
in mm / month.
}
\description{
Calculates mean PET of the coldest, warmest, wettest and driest quarters.
}
\details{
Generates mean monthly PET for the warmest, coldest, wettest and driest 
3 consecutive months.
}
\examples{
\dontrun{
# Find example rasters
rasterFiles <- list.files(system.file('extdata', package='envirem'), full.names=TRUE)
env <- stack(rasterFiles)

# identify the appropriate layers
meantemp <- grep('mean', names(env), value=TRUE)
solar <- grep('solrad', names(env), value=TRUE)
maxtemp <- grep('tmax', names(env), value=TRUE)
mintemp <- grep('tmin', names(env), value=TRUE)
precip <- grep('prec', names(env), value=TRUE)

# read them in as rasterStacks
meantemp <- stack(env[[meantemp]])
solar <- stack(env[[solar]])
maxtemp <- stack(env[[maxtemp]])
mintemp <- stack(env[[mintemp]])
tempRange <- abs(maxtemp - mintemp)
precip <- stack(env[[precip]])

# get monthly PET
pet <- monthlyPET(meantemp, solar, tempRange)

petExtremes(pet, precip, meantemp)
}
}
\author{
Pascal Title
}
\references{
Metzger, M.J., Bunce, R.G.H., Jongman, R.H.G., Sayre, R., Trabucco, A. & Zomer, R. (2013). 
A high-resolution bioclimate map of the world: a unifying framework for global 
biodiversity research and monitoring. \emph{Global Ecology and Biogeography}, 
\strong{22}, 630-638.
}
\seealso{
\code{\link{monthlyPET}}
}

