% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topoWetnessIndex.R
\name{topoWetnessIndex}
\alias{topoWetnessIndex}
\title{Topographic Wetness Index}
\usage{
topoWetnessIndex(dem, sagaEnv)
}
\arguments{
\item{dem}{elevation rasterLayer, with defined proj4string.}

\item{sagaEnv}{list object returned from \code{RSAGA::rsaga.env}, 
which supplies appropriate SAGA paths, and parallelization information.}
}
\value{
rasterLayer, unitless
}
\description{
SAGA-GIS topographic wetness index [DEPRECATED]
}
\details{
Recent updates appear to have broken this function, therefore it will be removed.

From a DEM, this function will write an appropriate raster
to disk, run an RSAGA function to calculate the topographic wetness index,
and will then read it back in and return it. 

This function requires that SAGA-GIS be installed on your system.
SAGA-GIS can be found at \url{www.saga-gis.org}. 

See the documentation for \code{RSAGA::rsaga.env} for specifying appropriate paths
and parallelization details.
}
\examples{
\dontrun{
# Find example rasters
rasterFiles <- list.files(system.file('extdata', package='envirem'), full.names=TRUE)
elev <- raster(grep('elev', rasterFiles, value=TRUE))

# setting up appropriate RSAGA environment
sagaEnv <- RSAGA::rsaga.env(modules = '/usr/lib/x86_64-linux-gnu/saga/', cores = 2, 
parallel = TRUE, version = "2.2.0")
topoWetnessIndex(elev, sagaEnv)
}
}
\author{
Pascal Title
}
\references{
Boehner, J., Koethe, R. Conrad, O., Gross, J., Ringeler, A. & Selige, T. (2002) Soil
regionalization by means of terrain analysis and process parameterization. \emph{Soil
Classification 2001 European Soil Bureau, Research Report No. 7} (eds Micheli, E., 
Nachtergaele, F. & Montanarella, L.), pp. 213-222. Luxembourg.

Conrad, O., Bechtel, B., Bock, M., Dietrich, H., Fischer, E., Gerlitz, L., Wehberg, J.,
Wichmann, V. & Böhner, J. (2015) System for automated geoscientific analyses (SAGA)
v. 2.1.4. \emph{Geoscientific Model Development}, \strong{8}, 1991-2007.
}

