% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continentality.R
\name{continentality}
\alias{continentality}
\title{Continentality}
\usage{
continentality(tmax, tmin, tempScale = 1)
}
\arguments{
\item{tmax}{rasterLayer of average temperature of the warmest month}

\item{tmin}{rasterLayer of average temperature of the coldest month}

\item{tempScale}{integer; scaling factor for the temperature data, see \link{envirem} for 
additional details.}
}
\value{
rasterLayer in units of degrees C.
}
\description{
Generate Continentality index.
}
\details{
\code{continentality index = tmax - tmin}
}
\examples{
\donttest{
# Find example rasters
rasterFiles <- list.files(system.file('extdata', package='envirem'), full.names=TRUE)
env <- stack(rasterFiles)

# identify appropriate layers
tmean <- grep('tmean', names(env))
tmin <- grep('tmin', names(env))
tmax <- grep('tmax', names(env))

tmean <- env[[tmean]]
tmin <- env[[tmin]]
tmax <- env[[tmax]]

# calculate temperature extremes
temp <- otherTempExtremes(tmean, tmin, tmax)

meantempWarmest <- temp[['meanTempWarmest']]
meantempColdest <- temp[['meanTempColdest']]

continentality(meantempWarmest, meantempColdest, tempScale = 10)
}
}
\references{
Rivas-Martínez, S. & Rivas-Sáenz, S. “Synoptical Worldwide Bioclimatic 
Classification System”.  Available online at \url{http://www.globalbioclimatics.org/}
[accessed 15 February 2016]

Sayre, R., Comer, P., Warner, H. & Cress, J. (2009) \emph{A new map of standardized
terrestrial ecosystems of the conterminous United States: US Geological Survey 
Professional Paper 1768}. Reston, VA.
}
\seealso{
\link{thermicityIndex}
}
\author{
Pascal Title
}
