% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{misClustRate}
\alias{misClustRate}
\title{Mis-Classification Rate (MCR)}
\usage{
misClustRate(cluster, truth)
}
\arguments{
\item{cluster}{vector of \code{integer} or \code{factor}, estimated cluster membership.}

\item{truth}{a vector of the same length as \code{clusters}, the true cluster labels.}
}
\value{
\code{numeric}, the MCR.
}
\description{
Compute the empirical MCR, assuming that #{cluster} = #{block},
This calculation allows a permutation on clusters.
}
\examples{
truth = rep(1:3, each = 30)
cluster = rep(3:1, times = c(25, 32, 33))
misClustRate(cluster, truth)
}
