% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_scc.R
\name{effect_size}
\alias{effect_size}
\title{Determine standardized effect size of component causes}
\usage{
effect_size(scc, depends = TRUE, output = c("nice", "table"))
}
\arguments{
\item{scc}{An object of class \code{epicmodel_scc}.}

\item{depends}{TRUE (default) or FALSE. If FALSE, only includes sufficient causes with suffciency status "always".}

\item{output}{A single element of type character, either "nice" (default) or "table". If "table", returns a data.frame. If "nice", a nicely
formated output is printed in the console.}
}
\value{
Either a dataframe (\code{output} = "table") with one row for every component cause and with variables \code{id} (step ID), \code{desc} (step
description), \code{suff_true}, \code{suff_false}, \code{num_combos_true}, \code{num_combos_false}, and \code{ratio}, or a nicely formated output in the console
(\code{output} = "nice"). See Details for more information.
}
\description{
SCC models teach us that effect strength, e.g., a risk ratio, is no natural constant but depends on the prevalence of component causes and,
therefore, differs between populations. However, even without any population, this function derives effect sizes for every component cause by
comparing how many sets of component causes with and without a certain cause are sufficient to cause the outcome of interest.
}
\details{
The following algorithm is used to derive effect sizes from SCC models:
\itemize{
\item The effect size is derived for one specific component cause. The following steps are repeated for all of them.
\item Get all potential combinations of component causes
\item Remove combinations that contain incompatible component causes (ICC), as specified in the steplist
\item Split the set of possible combinations of component causes into two parts: Sets, in which the component cause of interest is present & sets,
in which the component cause of interest is absent. The numbers are recorded and returned in the output table (output = "table") as variables
\code{num_combos_true} (cause is present) and \code{num_combos_false} (cause is absent). If there are no incompatible component causes (ICC), both
values should be the same.
\item Check for all possible combinations of component causes, if they are sufficient for the outcome to occur. The number of sufficient combinations
are counted separately for combinations with the component cause of interest present and combinations with the component cause of interest
absent. The numbers are recorded and returned in the output table (output = "table") as variables \code{suff_true} (cause is present) and
\code{suff_false} (cause is absent).
\item A ratio is calculated using the following formula: \code{(suff_true / num_combos_true) / (suff_false / num_combos_false)}. In the output table
(output = "table"), this value is stored in variable \code{ratio}. In the nice output (output = "nice"), it is reported in the column \code{Impact},
which shows: \verb{ratio [suff_true/num_combos_true vs. suff_false/num_combos_false]}
\item There are two special cases when calculating the \code{ratio}. When \code{suff_true > 0} but \code{suff_false == 0}, the outcome only occurs if the
corresponding component cause is present. The \code{ratio} then gets value \code{necessary}. When \code{suff_true == 0} and \code{suff_false == 0}, the \code{ratio}
gets value \verb{not a cause}.
}
}
\examples{
# Create some SCC model
steplist_checked <- check_steplist(steplist_rain)
scc_model <- create_scc(steplist_checked)

# Use the SCC model in effect_size()
effect_size(scc_model)
}
