% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thin.R
\name{thin}
\alias{thin}
\title{Thin data to retain matching linelist / contacts}
\usage{
thin(x, what = "linelist")
}
\arguments{
\item{x}{An \code{\link{epicontacts}} object.}

\item{what}{A character string or integer determining which type of data is
removed ('thinned'). "linelist" / 1 indicates that only cases appearing
in \code{$contacts} are kept in \code{$linelist}. "contacts / 2"
indicates that only cases appearing in \code{$linelist} are kept in
\code{$contacts}.}
}
\description{
This function can be used to remove ('thin') data from
\code{\link{epicontacts}} objects to ensure stricter matching of linelists
and contacts. It has two behaviours, triggered by the argument \code{what}:
either it thins data from \code{$linelist}, keeping only cases that are in
\code{$contacts} (\code{thin = "linelist"}, default), or the converse,
i.e. removing contacts which are not fully documented in the linelist.
}
\examples{
if (require(outbreaks)) {
## build data
x <- make_epicontacts(ebola_sim$linelist, ebola_sim$contacts,
                       id = "case_id", to = "case_id", from = "infector",
                       directed = TRUE)

## keep contacts from a specific case '916d0a'
x <- x[j = "916d0a", contacts = "from"]

}
}
\author{
Thibaut Jombart (\email{thibautjombart@gmail.com})
}
