% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epidatacall.R
\name{fetch_args_list}
\alias{fetch_args_list}
\alias{fetch_args}
\title{Customize fetch settings}
\usage{
fetch_args_list(
  ...,
  fields = NULL,
  disable_date_parsing = FALSE,
  disable_data_frame_parsing = FALSE,
  return_empty = FALSE,
  timeout_seconds = 30,
  base_url = NULL,
  dry_run = FALSE,
  debug = FALSE,
  format_type = "json"
)
}
\arguments{
\item{...}{not used for values, forces later arguments to bind by name}

\item{fields}{a list of epidata fields to return, or NULL to return all
fields (default) e.g. c("time_value", "value") to return only the
time_value and value fields or c("-direction") to return everything except
the direction field}

\item{disable_date_parsing}{disable automatic date parsing; by default \code{FALSE}}

\item{disable_data_frame_parsing}{disable automatic conversion to data frame; this
is only supported by endpoints that only support the 'classic' format (non-tabular).
by default \code{FALSE}}

\item{return_empty}{boolean that allows returning an empty tibble if there is no data;
by default \code{FALSE}}

\item{timeout_seconds}{the maximum amount of time to wait for a response; by default
\code{FALSE}}

\item{base_url}{base URL to use; by default \code{NULL}, which means the global base url
\code{"https://api.delphi.cmu.edu/epidata/"}}

\item{dry_run}{boolean that allows skipping the call to the API and instead
returns the \code{epidata_call} object (useful for debugging); by default \code{TRUE}}

\item{debug}{boolean that allows returning the raw response from the API; by default
\code{FALSE}}

\item{format_type}{the format to request from the API, one of classic, json, csv; this
is only used by \code{fetch_debug}, and by default is \code{"json"}}
}
\value{
\itemize{
\item For \code{fetch_args_list}: a \code{fetch_args} object
}
}
\description{
A constructor for \code{fetch_args} objects, which are used to pass arguments to
the \code{fetch} function.
}
