% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additional_priors.R
\name{shifted_gamma}
\alias{shifted_gamma}
\title{A shifted gamma prior}
\usage{
shifted_gamma(shape = 1, scale = 1, shift = 0, autoscale = TRUE)
}
\arguments{
\item{shape, scale}{Sets the shape and scale parameters of the Gamma prior.}

\item{shift}{The Gamma prior can be shifted to allow for positive support.}

\item{autoscale}{Same as in \code{\link[rstanarm]{priors}}.}
}
\value{
A named list to be parsed internally by \code{\link[epidemia]{epim}}.
}
\description{
A gamma prior distribution which can be shifted.
}
\details{
\pkg{rstanarm} provides a set of distributions
(see \code{\link[rstanarm]{priors}}) which can be used for the priors
on regression parameters. Intuitively, non-pharmaceutical interventions are
unlikely to a-priori cause a large increase in the reproduction number.
A shifted gamma prior can
be used to model this idea, and has been used in
\insertCite{Flaxman2020;textual}{epidemia}.  \code{shifted_gamma} can be
used as the \code{prior} argument
to \code{epim}. This specified a shifted gamma prior on the negative of the
regression parameters. i.e. if there is no shift, the support is on the
negative half of the real line.
}
\references{
\insertAllCited{}
}
