% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugs.R
\name{drugs_risk_factors}
\alias{drugs_risk_factors}
\title{Drugs for risk factors}
\usage{
drugs_risk_factors(trait, pval_threshold = 1e-08, mode = c("table", "raw"))
}
\arguments{
\item{trait}{A trait name}

\item{pval_threshold}{P-value threshold}

\item{mode}{If \code{mode = "table"}, returns a data frame
(a \href{https://tibble.tidyverse.org/}{\code{tibble}} as per
\href{https://style.tidyverse.org/}{\code{tidyverse}} convention).
If \code{mode = "raw"}, returns a raw response from EpiGraphDB API
with minimal parsing done by \href{https://httr.r-lib.org/}{\code{httr}}.}
}
\value{
Data from \code{GET /drugs/risk-factors}
}
\description{
\href{https://docs.epigraphdb.org/api/api-endpoints/#get-drugsrisk-factors}{\code{GET /drugs/risk-factors}}
}
\examples{
\dontrun{
drugs_risk_factors(trait = "Body mass index")
}
}
