% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cspring}
\alias{cspring}
\title{Colorado Springs network}
\format{
A list of two items the first ($nodes) is a frame with 749 rows and 6 variables, The second ($cm) is a 749 x 749 relational matrix of presence/absence of sexual contacts among each pair of individuals.
\describe{
\item{$nodes$id}{individual identifier}
\item{$nodes$gender}{gender; 1 = female, 2 = male}
\item{$nodes$sex.worker}{sex worker status; 1 = yes, 0 = no}
\item{$nodes$pimp}{pimp status; 1 = yes, 0 = no}
\item{$nodes$sex.work.client}{client status; 1 = yes, 2 = no}
\item{$nodes$type}{node classifier; 1 = client, 2 = worker, 3 = both}
\item{$cm}{the relational (contact) matrix among the individuals in the network.}}
}
\source{
Woodhouse et al. (1994) Mapping a social network of heterosexuals at high risk for HIV Infection. AIDS 8:1331-1336. doi:10.1097/00002030-199409000-00018

Klovdahl et al. (1994) Social networks and infectious disease: The Colorado Springs study. Social Science and Medicine 38:79-88. <doi:10.1016/0277-9536(94)90302-6>

\url{https://opr.princeton.edu/archive/p90/}
}
\usage{
cspring
}
\description{
Network and individual characteristics among 749 sex workers and clients in Colorado Springs as surveyed between 1988 and 1991
}
\keyword{datasets}
