% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatsir.R
\name{sirSpatmod}
\alias{sirSpatmod}
\title{Gradient function for a spatially-extended SIR model}
\usage{
sirSpatmod(t, y, parameters)
}
\arguments{
\item{t}{Implicit argument for time}

\item{y}{A vector of length L*3 with initial values for the states. The first 1:L represents initial S's, (L+1):2*L are initial I's and the last (2*L+1):3*L are initial R's}

\item{parameters}{A vector with parameter values for the spatial SIR system}
}
\value{
A list of gradients
}
\description{
Gradient function for a spatially-extended SIR model given some spatial topology
}
\examples{
require(deSolve)
require(ncf)
data(usflu)
usdist = gcdist(usflu$Longitude, usflu$Latitude)
G = gravity(0.3, 0.6, 3, usflu$Pop, usdist)
gamma = 1/3.5
R0 = 1.8
beta = R0 * gamma/usflu$Pop
m = 1 / 1000 / sum(usflu$Pop)
parms = list(beta = beta, m = m, gamma  =  gamma, G = G) 
S = usflu$Pop
R = I = rep(0, length(usflu$Pop))
I[31] = 1 
inits = c(S = S, I = I, R = R)  
times = 0:200
out = ode(inits, times, sirSpatmod, parms)
L=length(usflu$Pop)
\dontrun{matplot(out[, 50+(1:L)], type = "l", ylab = "Prevalence", xlab = "Day")}
}
