% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfuncs.R
\name{tau}
\alias{tau}
\title{Gillespie tau-leap algorithm}
\usage{
tau(rateqs, eventmatrix, parameters, initialvals, deltaT, endT)
}
\arguments{
\item{rateqs}{a list with rate equations}

\item{eventmatrix}{a matrix of changes in state variables associated with each event}

\item{parameters}{a vector of parameter values}

\item{initialvals}{a vector of initial values for the states}

\item{deltaT}{the tau-leap time interval}

\item{endT}{the time length of simulation}
}
\value{
A data frame with simulated time series
}
\description{
Function simulating a dynamical system using the Gillespie tau-leap approximation
}
\examples{
rlist2=c(quote(mu * (S+E+I+R)), quote(mu * S), quote(beta * S * I/(S+E+I+R)), 
 quote(mu*E), quote(sigma * E), quote(mu * I), quote(gamma * I), quote(mu*R))
emat2=matrix(c(1,0,0,0,-1,0,0,0,-1,1,0,0,0,-1,0,0,0,-1,1,0,0,0,-1,0,0,0,-1,1,0,0,0,-1),
ncol=4, byrow=TRUE)
paras  = c(mu = 1, beta =  1000, sigma = 365/8, gamma = 365/5)
inits = c(S=999, E=0, I=1, R = 0)
sim2=tau(rlist2, emat2, paras, inits, 1/365, 1)
}
