% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population_getters.R
\name{getIncMatrix}
\alias{getIncMatrix}
\title{Incidence matrix retrieval.}
\usage{
getIncMatrix(pop)
}
\arguments{
\item{pop}{An object of class \code{'Population'} which has an
\code{EpiNet} object attached.}
}
\value{
An incidence matrix representing the epistatic network
  within the given \code{Population} object.
}
\description{
Get an incidence matrix from a \code{Population}.
}
\details{
\code{getIncMatrix()} retrieves the incidence matrix used in
epistatic interactions within the given \code{Population} object.
This is most useful for copying the network structure to a new
\code{Population} object.
}
\examples{
# Create population
pop <- Population(
  popSize = 200, map = map100snp, QTL = 20,
  alleleFrequencies = runif(100),
  broadH2 = 0.9, narrowh2 = 0, traitVar = 40
)

# Attach random epistatic network and retrieve incidence matrix
pop <- attachEpiNet(pop)
inc <- getIncMatrix(pop)

# Create second population
pop2 <- Population(
  popSize = 200, map = map100snp, QTL = 20,
  alleleFrequencies = runif(100),
  broadH2 = 0.8, narrowh2 = 0.6, traitVar = 40
)

# Attach epistatic network to second population
# using incidence matrix from first
pop2 <- attachEpiNet(pop2, incmat = inc)
}
\seealso{
\code{\link{attachEpiNet}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
