% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epinetr_utils.R
\name{loadGeno}
\alias{loadGeno}
\title{Load epinetr genotype file.}
\usage{
loadGeno(filename)
}
\arguments{
\item{filename}{the filename for the epinetr genotypes file.}
}
\value{
a numeric matrix holding the genotypes
}
\description{
Load genotypes from a previous epinetr session.
}
\details{
When outputting all genotypes during an epinetr simulation run, the genotypes
will be written to a serialised format unique to epinetr. The \code{loadGeno}
function will load these genotypes into memory as a single matrix object.
}
\examples{
# Load genotype file
filename <- system.file("extdata", "geno.epi", package = "epinetr")
geno <- loadGeno(filename)

# Use genotypes as basis for new population
pop <- Population(
  map = map100snp, QTL = 20, genotypes = geno,
  broadH2 = 0.8, narrowh2 = 0.6, traitVar = 40
)
}
\seealso{
\code{\link{Population}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
