% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coercion.R
\name{as.function.epiparameter}
\alias{as.function.epiparameter}
\title{\code{\link[=as.function]{as.function()}} method for \verb{<epiparameter>} class}
\usage{
\method{as.function}{epiparameter}(x, func_type = c("density", "cdf", "generate", "quantile"), ...)
}
\arguments{
\item{x}{An \verb{<epiparameter>} object.}

\item{func_type}{A single \code{character} string specifying which distribution to
convert \verb{<epiparameter>} object into. Default is \code{"density"}. Other options
are \code{"cdf"}, \code{"generate"}, or \code{"quantile"}.}

\item{...}{\link{dots} Extra arguments to be passed to the method.}
}
\value{
A \link{function} object.
}
\description{
Converts an \verb{<epiparameter>} object to a distribution function
(see \link{epiparameter_distribution_functions}), either probability density/mass
function, (\code{density}), cumulative distribution function (\code{cdf}), random
number generator (\code{generate}), or quantile (\code{quantile}).
}
\details{
The function returned takes a single required argument \code{x}.
}
\examples{
ep <- epiparameter_db(single_epiparameter = TRUE)
# by default it will convert to a density function
f <- as.function(ep)
# use function
f(10)

f <- as.function(ep, func_type = "cdf")
f(10)
}
