% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle-factory.R
\name{smle_wrappers}
\alias{smle_wrappers}
\alias{smle_pois}
\alias{smle_nbinom}
\alias{smle_binom}
\alias{smle_betabinom}
\title{Wrappers using maximum likelihood estimation for some distributions}
\usage{
smle_pois(data)

smle_nbinom(data)

smle_binom(data)

smle_betabinom(data)
}
\arguments{
\item{data}{The data set to work with. It can be a vector (if there is only
one variable), a data frame (if there is one or more variables) or an
\code{\link{intensity}} object.}
}
\description{
These functions are the core of the fitting processes performed in
\code{\link{fit_two_distr}}.
}
\examples{
set.seed(12345)
data <- rpois(100, lambda = 5)
res <- smle_pois(data)
res
summary(res)

data <- count(aphids)
res <- smle_pois(data)
res
summary(res)

}
\keyword{internal}
