% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aim.R
\docType{package}
\name{episode}
\alias{episode}
\alias{episode-package}
\title{Estimation with Penalisation In Systems of Ordinary Differential Equations.}
\description{
This package provide the tools for approximate and exact parameter estimation in ODE models with regularisation via penalisation.
}
\section{Specify your ODE}{

The ode system is specified via the \code{\link{ode}}-subclasses: \code{\link{mak}}, \code{\link{plk}}, \code{\link{rlk}} and \code{\link{ratmak}}. In creating these you can also specify numerical solver type via \code{\link{solver}} and regularisation type of the parameter arguments via \code{\link{reg}}. To numerically solve the ODE use \code{\link{numsolve}} and to evaluate the ODE field use \code{\link{field}}. The differentials of both quantities can also be evaluated.
}

\section{Specify loss function}{

To specify the loss function use the \code{\link{reg}} in the ODE object to control regularisation and \code{\link{opt}} to control the observations, their weights and the tuning parameter of the regularisation.
}

\section{Optimise the loss function}{

Having an \code{\link{ode}} object and an \code{\link{opt}} object, there are two methods for estimating the parameters: approximate estimation via inverse collocation methods, \code{\link{aim}}, or exact estimation via interior point methods, \code{\link{rodeo}}. If desired, call \code{\link{rodeo}} on the results from \code{\link{aim}} to use the approximate estimates for initialising the exact estimation.
}

