% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_labels.R
\name{clean_labels}
\alias{clean_labels}
\title{Standardise labels}
\usage{
clean_labels(x, sep = "_")
}
\arguments{
\item{x}{A vector of labels, normally provided as characters.}

\item{sep}{A character string used as separator, defaulting to '_'.}
}
\description{
This function standardises labels e.g. used as variable names or character
string values, removing non-ascii characters, replacing diacritics (e.g. é,
ô) with their closest ascii equivalents, and standardises separating
characters. See details for more information on label transformation.\cr
}
\details{
The following changes are performed:

\itemize{

\item all non-ascii characters are removed

\item all diacritics are replaced with their non-accentuated equivalents,
e.g. 'é', 'ê' and 'è' become 'e', 'ö' becomes 'o', etc.

\item all characters are set to lower case

\item separators are standardised to the use of a single character provided
in \code{sep} (defaults to '_'); heading and trailing separators are removed.

}
}
\examples{

clean_labels("-_-This is; A    WeÏrD**./sêntënce...")
clean_labels("-_-This is; A    WeÏrD**./sêntënce...", sep = ".")
input <- c("Peter and stëven", "peter-and.stëven", "pëtêr and stëven  _-")
input
clean_labels(input)

}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
