% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelSIRDCONN.R
\name{ModelSIRDCONN}
\alias{ModelSIRDCONN}
\alias{epiworld_sirdconn}
\alias{plot.epiworld_sirdconn}
\title{Susceptible Infected Removed Deceased model (SIRD connected)}
\usage{
ModelSIRDCONN(
  name,
  n,
  prevalence,
  contact_rate,
  transmission_rate,
  recovery_rate,
  death_rate
)

\method{plot}{epiworld_sirdconn}(x, main = get_name(x), ...)
}
\arguments{
\item{name}{String. Name of the virus}

\item{n}{Number of individuals in the population.}

\item{prevalence}{Double. Initial proportion of individuals with the virus.}

\item{contact_rate}{Numeric scalar. Average number of contacts per step.}

\item{transmission_rate}{Numeric scalar between 0 and 1. Probability of
transmission.}

\item{recovery_rate}{Numeric scalar between 0 and 1. Probability of recovery.}

\item{death_rate}{Numeric scalar between 0 and 1. Probability of death.}

\item{x}{Object of class SIRDCONN.}

\item{main}{Title of the plot}

\item{...}{Currently ignore.}
}
\value{
\itemize{
\item The \code{ModelSIRDCONN}function returns a model of class \link{epiworld_model}.
}

The \code{plot} function returns a plot of the SIRDCONN model of class
\link{epiworld_model}.
}
\description{
Susceptible Infected Removed Deceased model (SIRD connected)
}
\details{
The \link{initial_states} function allows the user to set the initial state of the
model. The user must provide a vector of proportions indicating the following
values: (1) proportion of non-infected agents already removed, and (2) proportion of
non-ifected agents already deceased.
}
\examples{
model_sirdconn <- ModelSIRDCONN(
  name                = "COVID-19",
  n                   = 100000,
  prevalence          = 0.01,
  contact_rate        = 5,
  transmission_rate   = 0.4,
  recovery_rate       = 0.5,
  death_rate          = 0.1
)
  
# Running and printing
run(model_sirdconn, ndays = 100, seed = 1912)
model_sirdconn

plot(model_sirdconn,  main = "SIRDCONN Model")
}
\seealso{
epiworld-methods

Other Models: 
\code{\link{ModelDiffNet}()},
\code{\link{ModelSEIRCONN}()},
\code{\link{ModelSEIRDCONN}()},
\code{\link{ModelSEIRD}()},
\code{\link{ModelSEIR}()},
\code{\link{ModelSIRCONN}()},
\code{\link{ModelSIRD}()},
\code{\link{ModelSIRLogit}()},
\code{\link{ModelSIR}()},
\code{\link{ModelSISD}()},
\code{\link{ModelSIS}()},
\code{\link{ModelSURV}()},
\code{\link{epiworld-data}}
}
\concept{Models}
