% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{epiworld-data}
\alias{epiworld-data}
\alias{get_hist_total}
\alias{epiworld_hist_total}
\alias{get_today_total}
\alias{get_hist_virus}
\alias{epiworld_hist_variant}
\alias{epiworld_hist_virus}
\alias{get_hist_tool}
\alias{epiworld_hist_tool}
\alias{get_transition_probability}
\alias{get_reproductive_number}
\alias{epiworld_repnum}
\alias{plot.epiworld_repnum}
\alias{plot_reproductive_number}
\alias{get_hist_transition_matrix}
\alias{as.array.epiworld_hist_transition}
\alias{plot_incidence}
\alias{plot.epiworld_hist_transition}
\alias{get_transmissions}
\alias{get_generation_time}
\alias{plot.epiworld_generation_time}
\alias{plot_generation_time}
\title{Accessing the database of epiworld}
\usage{
get_hist_total(x)

get_today_total(x)

get_hist_virus(x)

get_hist_tool(x)

get_transition_probability(x)

get_reproductive_number(x)

\method{plot}{epiworld_repnum}(
  x,
  y = NULL,
  ylab = "Average Rep. Number",
  xlab = "Day (step)",
  main = "Reproductive Number",
  type = "b",
  plot = TRUE,
  ...
)

plot_reproductive_number(x, ...)

get_hist_transition_matrix(x, skip_zeros = FALSE)

\method{as.array}{epiworld_hist_transition}(x, ...)

plot_incidence(x, ...)

\method{plot}{epiworld_hist_transition}(
  x,
  type = "b",
  xlab = "Day (step)",
  ylab = "Counts",
  main = "Daily incidence",
  plot = TRUE,
  ...
)

get_transmissions(x)

get_generation_time(x)

\method{plot}{epiworld_generation_time}(
  x,
  type = "b",
  xlab = "Day (step)",
  ylab = "Avg. Generation Time",
  main = "Generation Time",
  plot = TRUE,
  ...
)

plot_generation_time(x, ...)
}
\arguments{
\item{x}{An object of class \code{\link{epiworld_sir}}, \code{\link{epiworld_seir}}, etc.
any model.}

\item{y}{Ignored.}

\item{ylab, xlab, main, type}{Further parameters passed to \code{\link[graphics:plot.default]{graphics::plot()}}}

\item{plot}{Logical scalar. If \code{TRUE} (default), the function will the
desired statistic.}

\item{...}{In the case of plot methods, further arguments passed to
\link[graphics:plot.default]{graphics::plot}.}

\item{skip_zeros}{Logical scalar. When \code{FALSE} it will return all the
entries in the transition matrix.}
}
\value{
\itemize{
\item The \code{get_hist_total} function returns an object of class
\link{epiworld_hist_total}.
}

\itemize{
\item The \code{get_today_total} function returns a named vector with the
total number of individuals in each state at the end of the simulation.
}

\itemize{
\item The \code{get_hist_virus} function returns an object of class
\link{epiworld_hist_virus}.
}

\itemize{
\item The \code{get_hist_tool} function returns an object of \link{epiworld_hist_virus}.
}

\itemize{
\item The \code{get_transition_probability} function returns an object of class
\code{matrix}.
}

\itemize{
\item The \code{get_reproductive_number} function returns an object of class
\link{epiworld_repnum}.
}

\itemize{
\item The \code{plot} function returns a plot of the reproductive number over time.
}

\itemize{
\item \code{get_hist_transition_matrix} returns a \link{data.frame} with four columns:
"state_from", "state_to", "date", and "counts."
}

\itemize{
\item The \code{as.array} method for \code{epiworld_hist_transition} objects turns the
\code{data.frame} returned by \code{get_hist_transition_matrix} into an array of
\verb{nstates x nstates x (ndays + 1)}
entries, where the first entry is the initial state.
}

\itemize{
\item The \code{plot_incidence} function returns a plot originating from the object
\code{get_hist_transition_matrix}.
}

\itemize{
\item The \code{plot} function returns a plot which originates from the
\code{epiworld_hist_transition} object.
}

\itemize{
\item The function \code{get_transmissions} returns a \code{data.frame} with the following
columns: \code{date}, \code{source}, \code{target}, \code{virus_id}, \code{virus}, and \code{source_exposure_date}.
}

\itemize{
\item The function \code{get_generation_time} returns a \code{data.frame} with
the following columns: "agent", "virus_id", "virus", "date", and "gentime".
}

\itemize{
\item The function \code{plot_generation_time} is a wrapper for \link{plot} and
\link{get_generation_time}.
}
}
\description{
Models in \code{epiworld} are stored in a database. This database can be accessed
using the functions described in this manual page. Some elements of the
database are: the transition matrix, the incidence matrix, the reproductive
number, the generation time, and daily incidence at the virus and tool level.
}
\details{
The \code{plot_reproductive_number} function is a wrapper around
\link{get_reproductive_number} that plots the result.

The \code{plot_incidence} function is a wrapper between
\link{get_hist_transition_matrix} and it's plot method.

The plot method for the \code{epiworld_hist_transition} class plots the
daily incidence of each state. The function returns the data frame used for
plotting.

The function \code{get_transmissions} includes the seeded infections, with the
\code{source} column coded as \code{-1}.
}
\examples{
# SEIR Connected
seirconn <- ModelSEIRCONN(
  name              = "Disease",
  n                 = 10000,
  prevalence        = 0.1,
  contact_rate      = 2.0,
  transmission_rate = 0.8,
  incubation_days   = 7.0,
  recovery_rate     = 0.3
)

# Running the simulation for 50 steps (days)
set.seed(937)
run(seirconn, 50)

# Retrieving the transition probability
get_transition_probability(seirconn)

# Retrieving date, state, and counts dataframe including any added tools
get_hist_tool(seirconn)

# Retrieving overall date, state, and counts dataframe
head(get_hist_total(seirconn))

# Retrieving date, state, and counts dataframe by variant
head(get_hist_virus(seirconn))

# Retrieving (and plotting) the reproductive number
rp <- get_reproductive_number(seirconn)
plot(rp) # Also equivalent to plot_reproductive_number(seirconn)

# We can go further and get all the history
t_hist <- get_hist_transition_matrix(seirconn)

head(t_hist)

# And turn it into an array
as.array(t_hist)[, , 1:3]

# We cam also get (and plot) the incidence, as well as
# the generation time
inci <- plot_incidence(seirconn)
gent <- plot_generation_time(seirconn)

}
\seealso{
Other Models: 
\code{\link{ModelDiffNet}()},
\code{\link{ModelMeaslesQuarantine}()},
\code{\link{ModelSEIR}()},
\code{\link{ModelSEIRCONN}()},
\code{\link{ModelSEIRD}()},
\code{\link{ModelSEIRDCONN}()},
\code{\link{ModelSEIRMixing}()},
\code{\link{ModelSIR}()},
\code{\link{ModelSIRCONN}()},
\code{\link{ModelSIRD}()},
\code{\link{ModelSIRDCONN}()},
\code{\link{ModelSIRLogit}()},
\code{\link{ModelSIRMixing}()},
\code{\link{ModelSIS}()},
\code{\link{ModelSISD}()},
\code{\link{ModelSURV}()}
}
\concept{Models}
