% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idfobj-sch.R
\docType{class}
\name{IdfSchedule}
\alias{IdfSchedule}
\alias{schedule_compact}
\alias{IdfScheduleCompact}
\title{Create an \code{IdfScheduleCompact} object.}
\usage{
schedule_compact(parent, name, new = FALSE)
}
\arguments{
\item{parent}{An \link{Idf} object.}

\item{name}{A valid name (a string) for a \code{Schedule:Compact} object.}

\item{new}{If \code{TRUE}, a new empty \link{IdfScheduleCompact} is created. Default:
\code{FALSE}.}
}
\value{
An \link{IdfScheduleCompact} object.
}
\description{
\code{schedule_compact()} takes a parent \code{Idf} object, a name for
\code{Schedule:Compact} object, and returns a corresponding \link{IdfScheduleCompact}
object.

\code{IdfScheduleCompact} is an abstraction of a single \code{Schedule:Compact} object
in an \link{Idf}. It provides more detailed methods to add, modify and extract
schedule values.
}
\details{
If \code{new} is \code{TRUE}, an empty \link{IdfScheduleCompact} is created,
with all field values being empty. The empty \link{IdfScheduleCompact} is directly
added into the parent \link{Idf} object. It is recommended to use \verb{$validate()}
method in \link{IdfScheduleCompact} to see what kinds of further modifications are
needed for those empty fields and use \verb{$set()} and \verb{$update()} method to set
field values.
}
\examples{

## ------------------------------------------------
## Method `IdfScheduleCompact$new`
## ------------------------------------------------

\dontrun{
model <- read_idf(system.file("extdata/1ZoneUncontrolled.idf", package = "eplusr"))

# create an empty 'Schedule:Compact'
schedule_compact(model, "sch", TRUE)

# get an existing 'Schedule:Compact'
sch <- schedule_compact(model, "sch")
}

## ------------------------------------------------
## Method `IdfScheduleCompact$set`
## ------------------------------------------------

\dontrun{
sch$set(c("weekday", "summerdesignday") := list(
    ..6 = 0.2, "8:00" = 0.5,
    ..12 = 0.95, "13:30" = 0.6, ..14 = 0.8,
    ..18 = 0.95, ..19 = 0.2, ..24 = 0),
    allotherday = list(..24 = 0)
)
}

## ------------------------------------------------
## Method `IdfScheduleCompact$update`
## ------------------------------------------------

\dontrun{
sch$update(sch$extract())

val1 <- data.table::data.table(
    year_day = "12/31",
    daytype = "weekday,summerdesignday",
    time = c("6:00", "8:00", "12:00", "13:30", "14:00", "18:00", "19:00", "24:00"),
    value = c(0.2,    0.5,    0.95,    0.6,     0.8,     0.95,    0.2,     0.0)
)
val2 <- data.table::data.table(
    year_day = "12/31", daytype = "allotherday",
    time = "24:00", value = 0.0
)
val <- data.table::rbindlist(list(val1, val2))
sch$update(val)
}

## ------------------------------------------------
## Method `IdfScheduleCompact$validate`
## ------------------------------------------------

\dontrun{
sch$validate()

# check at predefined validate level
sch$validate("none")
sch$validate("draft")
sch$validate("final")
}

## ------------------------------------------------
## Method `IdfScheduleCompact$is_valid`
## ------------------------------------------------

\dontrun{
sch$is_valid()
}


## ------------------------------------------------
## Method `IdfScheduleCompact$extract`
## ------------------------------------------------

\dontrun{
sch$extract()
sch$extract("expand")
sch$extract(timestep = "30 mins")
}
}
\seealso{
\link{Idf} class
}
\author{
Hongyuan Jia
}
\section{Super classes}{
\code{\link[eplusr:IdfObject]{eplusr::IdfObject}} -> \code{\link[eplusr:IdfSchedule]{eplusr::IdfSchedule}} -> \code{IdfScheduleCompact}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-IdfScheduleCompact-new}{\code{IdfScheduleCompact$new()}}
\item \href{#method-IdfScheduleCompact-type_limits}{\code{IdfScheduleCompact$type_limits()}}
\item \href{#method-IdfScheduleCompact-set}{\code{IdfScheduleCompact$set()}}
\item \href{#method-IdfScheduleCompact-update}{\code{IdfScheduleCompact$update()}}
\item \href{#method-IdfScheduleCompact-validate}{\code{IdfScheduleCompact$validate()}}
\item \href{#method-IdfScheduleCompact-is_valid}{\code{IdfScheduleCompact$is_valid()}}
\item \href{#method-IdfScheduleCompact-extract}{\code{IdfScheduleCompact$extract()}}
\item \href{#method-IdfScheduleCompact-clone}{\code{IdfScheduleCompact$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="class_name"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-class_name'><code>eplusr::IdfObject$class_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="comment"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-comment'><code>eplusr::IdfObject$comment()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="definition"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-definition'><code>eplusr::IdfObject$definition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="group_name"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-group_name'><code>eplusr::IdfObject$group_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="has_ref"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-has_ref'><code>eplusr::IdfObject$has_ref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="has_ref_by"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-has_ref_by'><code>eplusr::IdfObject$has_ref_by()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="has_ref_node"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-has_ref_node'><code>eplusr::IdfObject$has_ref_node()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="has_ref_to"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-has_ref_to'><code>eplusr::IdfObject$has_ref_to()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="id"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-id'><code>eplusr::IdfObject$id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="name"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-name'><code>eplusr::IdfObject$name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="parent"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-parent'><code>eplusr::IdfObject$parent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="print"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-print'><code>eplusr::IdfObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="ref_by_object"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-ref_by_object'><code>eplusr::IdfObject$ref_by_object()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="ref_to_node"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-ref_to_node'><code>eplusr::IdfObject$ref_to_node()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="ref_to_object"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-ref_to_object'><code>eplusr::IdfObject$ref_to_object()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="to_string"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-to_string'><code>eplusr::IdfObject$to_string()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="to_table"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-to_table'><code>eplusr::IdfObject$to_table()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="value"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-value'><code>eplusr::IdfObject$value()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="value_possible"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-value_possible'><code>eplusr::IdfObject$value_possible()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="value_relation"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-value_relation'><code>eplusr::IdfObject$value_relation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="IdfObject" data-id="version"><a href='../../eplusr/html/IdfObject.html#method-IdfObject-version'><code>eplusr::IdfObject$version()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IdfScheduleCompact-new"></a>}}
\if{latex}{\out{\hypertarget{method-IdfScheduleCompact-new}{}}}
\subsection{Method \code{new()}}{
Create an \code{IdfScheduleCompact} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfScheduleCompact$new(object, parent, new = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{object}}{An integer specifying an object ID.}

\item{\code{parent}}{An \link{Idf} object specifying the parent object.}

\item{\code{new}}{If \code{TRUE}, an empty \code{IdfScheduleCompact} will be created.
Default: \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{IdfScheduleCompact} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
model <- read_idf(system.file("extdata/1ZoneUncontrolled.idf", package = "eplusr"))

# create an empty 'Schedule:Compact'
schedule_compact(model, "sch", TRUE)

# get an existing 'Schedule:Compact'
sch <- schedule_compact(model, "sch")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IdfScheduleCompact-type_limits"></a>}}
\if{latex}{\out{\hypertarget{method-IdfScheduleCompact-type_limits}{}}}
\subsection{Method \code{type_limits()}}{
Get or set the schedule type limits
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfScheduleCompact$type_limits(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{A string specifying the name of an \code{ScheduleTypeLimits}
object in current \link{Idf}. If missing, value of last time will
be used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of 2 elements:
\itemize{
\item \code{name}: The name of the \code{ScheduleTypeLimits} object
\item \code{range}: The range of current schedule values
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IdfScheduleCompact-set"></a>}}
\if{latex}{\out{\hypertarget{method-IdfScheduleCompact-set}{}}}
\subsection{Method \code{set()}}{
Set schedule values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfScheduleCompact$set(..., .check_range = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Schedule day types and value specifications in lists.
\itemize{
\item Group day types inside \code{c(...)} at the LHS of \verb{:=}
\item Put actual schedule values inside \code{list(...)} at the RHS of \verb{:=}
\item Each schedule value should be named a time. Time can be given in
either \code{..H} or \code{"HH:MM"}.
}}

\item{\code{.check_range}}{If \code{TRUE}, schedule values will be checked based
on \verb{$type_limits()}. Default: \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Please note that all schedules will be applied for all days in a
year. For detailed modifications, please check \verb{$update()} method
which accepts data.frame input.
}

\subsection{Returns}{
The modified \code{IdfScheduleCompact} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
sch$set(c("weekday", "summerdesignday") := list(
    ..6 = 0.2, "8:00" = 0.5,
    ..12 = 0.95, "13:30" = 0.6, ..14 = 0.8,
    ..18 = 0.95, ..19 = 0.2, ..24 = 0),
    allotherday = list(..24 = 0)
)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IdfScheduleCompact-update"></a>}}
\if{latex}{\out{\hypertarget{method-IdfScheduleCompact-update}{}}}
\subsection{Method \code{update()}}{
Update schedule values using data.frame
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfScheduleCompact$update(data, check_range = TRUE, compact = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data.frame of at least 4 columns:
\itemize{
\item \code{year_day}: Used for the \verb{Through:} fields. Can be in one of the
following formats:
\itemize{
\item \code{character}: Day specifications in either \code{mm/dd} or \code{mm-dd}
where \code{mm} is the month in \code{1:12} or in character and \code{dd} is the
day in month in \code{1:31}
\item \code{Date}: The year component will be ignored and only the month and
day component will be used
\item \code{integer}: Julian day, e.g. \code{360}, \code{365} and etc
}
\item \code{id} (Optional): Integer type. Used to group together different day
types with same schedule values.  Grouped day types will be
compacted in a single \verb{For:} field, e.g. \verb{For: Weekdays SummaryDesignDay}. Grouped day types should have the same schedule
values. Otherwise an error will be issued.
\item \code{daytype}: Character type. Used for the \verb{For:} fields. All possible
values are listed below. Case-insensitive matching is used.
Different day types can be grouped using the \code{id} column mentioned
above or put together directly in a single string separate by comma
(\verb{,}), e.g. \code{"weekend, holiday"}
\itemize{
\item \code{"AllDay(s)"}
\item \code{"Weekday(s)"}, and also \code{"Monday"}, \code{"Tuesday"}, \code{"Wednesday"},
\code{"Thursday"} and \code{"Friday"}
\item \code{"Weekend(s)"}, and also \code{"Saturday"} and \code{"Sunday"}
\item \code{"SummaryDesignDay"} and \code{"WinterDesignDay"}
\item \code{"Holiday"}
\item \code{"CustomDay1"} and \code{"CustomDay2"}
\item \code{"AllOtherDay(s)"}
}
\item \code{time}: Used for the \verb{Until:} fields. Can be in one of the
following formats:
\itemize{
\item \code{character}: Time specifications in \code{HH:MM}
where \code{HH} is the hour in \code{0:24} and \code{MM} is the
minute in \code{0:60}
\item \code{integer}: Time differences from \code{00:00:00} in \strong{minutes}, e.g.
\code{seq(60, 60 * 24, by = 60)}
\item \code{hms}: \code{hms} objects constructed using \code{hms::hms()} or
equivalents, e.g.  \code{hms::hms(minutes = 30, hours = 1)}, and
\code{hms::as_hms("1:30:00")}
\item \code{difftime}: \code{difftime} objects constructed using \code{as.difftime()}
or equivalents, e.g. \code{as.difftime(1:24, units = "hours")}
\item \code{ITime}: \code{ITime} objects constructed using
\code{data.table::as.ITime()}, e.g. \code{as.ITime("01:30:00")}
}
\item \code{value}: Numeric type. Used for the actual schedule values
}}

\item{\code{check_range}}{If \code{TRUE}, schedule values will be checked based
on \verb{$type_limits()}. Default: \code{TRUE}.}

\item{\code{compact}}{If \code{TRUE}, same schedule values from different day
types will be compacted together.  Also, time periods that
have the same schedule values will also be compacted.
Note that only \code{"Holiday"}, \code{"CustomDay1"} and \code{"CustomDay2"}
will be compacted into \code{"AllOtherDays"}. For example, if the
\code{daytype} column contains only \code{"Weekdays"},
\code{"SummerDesignDay"} and \code{"AllOtherDays"}, \code{"AllOtherDays"}
will be expanded to \code{"Weekends"}, \code{"WinterDesignDay"} and
\code{"AllOtherDays"}.  Default: \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The modified \code{IdfScheduleCompact} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
sch$update(sch$extract())

val1 <- data.table::data.table(
    year_day = "12/31",
    daytype = "weekday,summerdesignday",
    time = c("6:00", "8:00", "12:00", "13:30", "14:00", "18:00", "19:00", "24:00"),
    value = c(0.2,    0.5,    0.95,    0.6,     0.8,     0.95,    0.2,     0.0)
)
val2 <- data.table::data.table(
    year_day = "12/31", daytype = "allotherday",
    time = "24:00", value = 0.0
)
val <- data.table::rbindlist(list(val1, val2))
sch$update(val)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IdfScheduleCompact-validate"></a>}}
\if{latex}{\out{\hypertarget{method-IdfScheduleCompact-validate}{}}}
\subsection{Method \code{validate()}}{
Check possible object field value errors
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfScheduleCompact$validate(level = eplusr_option("validate_level"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{One of \code{"none"}, \code{"draft"}, \code{"final"} or a list of 10
elements with same format as \code{\link[=custom_validate]{custom_validate()}} output.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\verb{$validate()} checks if there are errors in current
\code{IdfScheduleCompact} object under specified validation level and
returns an \code{IdfValidity} object.
Schedule value ranges will be checked if current validate level
contains range checking (if corresponding \code{ScheduleTypeLimits}
\verb{Numeric Type} is \code{Continuous}) or choice checking (if corresponding
\code{ScheduleTypeLimits} \verb{Numeric Type} is \code{Discrete}).

For detailed description on validate checking, see
\href{../../eplusr/html/IdfObject.html#method-validate}{\code{IdfObject$validate()}}
documentation above.
}

\subsection{Returns}{
An \code{IdfValidity} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
sch$validate()

# check at predefined validate level
sch$validate("none")
sch$validate("draft")
sch$validate("final")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IdfScheduleCompact-is_valid"></a>}}
\if{latex}{\out{\hypertarget{method-IdfScheduleCompact-is_valid}{}}}
\subsection{Method \code{is_valid()}}{
Check if there is any error in current object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfScheduleCompact$is_valid(level = eplusr_option("validate_level"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{One of \code{"none"}, \code{"draft"}, \code{"final"} or a list of 10
elements with same format as \code{\link[=custom_validate]{custom_validate()}} output.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\verb{$is_valid()} returns \code{TRUE} if there is no error in current
\code{IdfScheduleCompact} object under specified validation level.
Schedule value ranges will be checked if current validate level
contains range checking (if corresponding \code{ScheduleTypeLimits}
\verb{Numeric Type} is \code{Continuous}) or choice checking (if corresponding
\code{ScheduleTypeLimits} \verb{Numeric Type} is \code{Discrete}).

\verb{$is_valid()} checks if there are errors in current \code{IdfObject} object
under specified validation level and returns \code{TRUE} or \code{FALSE}
accordingly. For detailed description on validate checking, see
\href{../../eplusr/html/IdfObject.html#method-validate}{\code{IdfObject$validate()}}
documentation above.
}

\subsection{Returns}{
A single logical value of \code{TRUE} or \code{FALSE}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
sch$is_valid()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IdfScheduleCompact-extract"></a>}}
\if{latex}{\out{\hypertarget{method-IdfScheduleCompact-extract}{}}}
\subsection{Method \code{extract()}}{
Extract schedule values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfScheduleCompact$extract(daytype = NULL, timestep = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{daytype}}{Should be one of:
\itemize{
\item \code{NULL}: Do nothing Grouped day types will be concatenated with a
comma, e.g. \verb{Weekdays,SummerDesignDay}. This is the default
behavior.
\item \code{TRUE} or \code{"expand"}: All compacted day types will be expanded.
\item \code{FALSE} or \code{"compact"}: Same schedule values from different day
types will be compacted together.
\item A character vector specifying the grouped day types, e.g.
\code{c("weekday", "summerdesignday")}. All other days except specified
ones will be classified into day type \code{AllOtherDays}, if possible.
If not possible, those day types will still be extracted
separately.
}}

\item{\code{timestep}}{The time step of schedule values, e.g. "10 mins" and
"1 hour". Valid units include \code{sec(s)}, \code{min(s)}, and
\code{hour(s)}. If \code{NULL}, the original time specifications will be
kept. If \code{"auto"}, the time periods with the same schedule
values will be compacted. Default: \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} if current schedule is empty. Otherwise, a
\code{\link[data.table:data.table]{data.table::data.table()}} of 5 columns:
\itemize{
\item \code{year_day}: Character type. Used for the \verb{Through:} fields.
Day specifications in \code{mm/dd} format
\item \code{id}: Integer type. The group index of day types
\item \code{daytype}: Character type. Used for the \verb{For:} fields. All possible
values are:
\itemize{
\item \code{"AllDay"}
\item \code{"Weekday"}, and also \code{"Monday"}, \code{"Tuesday"}, \code{"Wednesday"},
\code{"Thursday"} and \code{"Friday"}
\item \code{"Weekend"}, and also \code{"Saturday"} and \code{"Sunday"}
\item \code{"SummaryDesignDay"} and \code{"WinterDesignDay"}
\item \code{"Holiday"}
\item \code{"CustomDay1"} and \code{"CustomDay2"}
\item \code{"AllOtherDay"}
}
\item \code{time}: \code{hms} vector. Used for the \verb{Until:} fields. It is handy for
plotting since \code{hms} object is directly supported by the scale
system of \href{https://cran.r-project.org/package=ggplot2}{ggplot2}
package
\item \code{value}: Numeric type. Actual schedule values
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
sch$extract()
sch$extract("expand")
sch$extract(timestep = "30 mins")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IdfScheduleCompact-clone"></a>}}
\if{latex}{\out{\hypertarget{method-IdfScheduleCompact-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfScheduleCompact$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
