% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param.R
\docType{class}
\name{param}
\alias{param}
\title{Create and Run Parametric Analysis, and Collect Results}
\description{
\code{ParametricJob} class provides a prototype of conducting parametric analysis
of EnergyPlus simulations.
}
\details{
Basically, it is a collection of multiple \code{EplusJob} objects.
}
\section{Usage}{
\preformatted{param <- param_job(idf, epw)
param$apply_measure(measure, ..., .names = NULL)
param$run(dir = NULL, parallel_backend = future::multiprocess)
param$kill(which = NULL)
param$status(which = NULL)
param$errors(info = FALSE)
param$output_dir(which = NULL)
param$locate_output(which = NULL, suffix = ".err", strict = TRUE)
param$report_data_dict(which = NULL)
param$report_data(which = NULL, key_value = NULL, name = NULL, year = NULL, tz = "GMT", case = "auto")
param$tabular_data(which = NULL)
param$print()
}
}

\section{Create}{
\preformatted{param <- param_job(idf, epw)
}

\strong{Arguments}
\itemize{
\item \code{idf}: Path to EnergyPlus IDF or IMF file or an \code{Idf} object.
\item \code{epw}: Path to EnergyPlus EPW file or an \code{Epw} object.
}
}

\section{Get Seed Model and Weather}{
\preformatted{param$seed()
param$weather()
}

\code{$seed()} will return the input \code{Idf} object.

\code{$weather()} will return the input \code{Epw} object.
}

\section{Apply Design Alternatives}{
\preformatted{param$apply_measure(measure, ..., .names = NULL)
}

\code{$apply_measure()} allows to apply a measure to an \code{Idf} and creates
parametric models for analysis. Basically, a measure is just a function
that takes an \code{Idf} object and other arguments as input, and returns a
modified \code{Idf} object as output. Use \code{...} to supply different arguments
to that measure. Under the hook, \code{\link[=mapply]{mapply()}} is used to create multiple
\code{Idf}s according to the input values.

\strong{Arguments}
\itemize{
\item \code{measure}: A function that takes an \code{Idf} and other arguments as input and
returns an \code{Idf} object as output.
\item \code{...}: Other arguments passed to that \code{measure}.
\item \code{.names}: A character vector of the names of parametric \code{Idf}s. If \code{NULL},
the new \code{Idf}s will be named in format \code{measure_name + number}.
}
}

\section{Run and Collect Results}{
\preformatted{param$run(dir = NULL, parallel_backend = future::multiprocess)
param$kill(which = NULL)
param$status(which = NULL)
param$errors(info = FALSE)
param$output_dir(which = NULL)
param$locate_output(which = NULL, suffix = ".err", strict = TRUE)
param$report_data_dict(which = NULL)
param$report_data(which = NULL, key_value = NULL, name = NULL, year = NULL, tz = "GMT", case = "auto")
param$tabular_data(which = NULL)
}

All those functions have the same meaning in \link[=job]{EplusJob class}, except that they
only return the results of specified simulation.

\strong{Arguments}
\itemize{
\item \code{which}: An integer vector of the indexes or a character vector or names of
parametric simulations.
\item \code{parallel_backend}: Any acceptable input for \code{\link[future:plan]{future::plan()}}.
}

All other arguments have the same meanings as in \link[=job]{EplusJob class}.
}

\author{
Hongyuan Jia
}
