% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm.ego.R
\name{ergm.ego}
\alias{ergm.ego}
\title{Inference for Exponential-Family Random Graph Models based on Egocentrically
Sampled Data}
\usage{
ergm.ego(
  formula,
  popsize = 1,
  offset.coef = NULL,
  constraints = ~.,
  ...,
  basis = eval_lhs.formula(formula),
  control = control.ergm.ego(),
  na.action = na.fail,
  na.rm = FALSE,
  do.fit = TRUE
)
}
\arguments{
\item{formula}{A \code{\link{formula}} object, of the form \code{e
  ~ <model terms>}, where \code{e} is a \code{\link[egor:egor]{egor}}
object. See \code{\link[ergm:ergm]{ergm()}} for details and examples.

For a list of currently implemented egocentric terms for the RHS, see
\code{\link{ergm.ego-terms}}.}

\item{popsize}{The size \eqn{|N|} of the finite population network
from which the egocentric sample was taken; only affects the
shift in the coefficients of the terms modeling the overall
propensity to have ties.  Setting it to 1 (the default)
essentially uses the \eqn{-\log |N'|} offset on the edges
term. Passing 0 disables network size adjustment and uses the
egocentric sample size; passing \code{\link[=I]{I(N)}} uses the specified
size \code{N} (though can be overridden by the \code{ppop}
\code{\link[=control.ergm.ego]{control.ergm.ego()}} option) and disables network size
adjustment.}

\item{offset.coef}{A vector of coefficients for the offset terms.}

\item{constraints}{A one-sided formula \code{\link{formula}} giving
the sample space constraints. See \code{\link[ergm:ergm]{ergm()}} for
details and examples.}

\item{\dots}{Additional arguments passed to \code{\link[ergm:ergm]{ergm()}}.}

\item{basis}{a value (usually an \code{\link[egor:egor]{egor}}) to override the LHS of the formula.}

\item{control}{A \code{\link[=control.ergm.ego]{control.ergm.ego()}} control list.}

\item{na.action}{How to handle missing actor attributes in egos or alters,
when the terms need them for  models that scale.}

\item{na.rm}{How to handle missing actor attributes in egos or alters,
when the terms need them for models that do not scale.}

\item{do.fit}{Whether to actually call \code{\link[ergm:ergm]{ergm()}}}
}
\value{
An object of class \code{\link{ergm.ego}} inheriting from
\code{\link[ergm:ergm]{ergm}}, with the following additional or overridden
elements:
\item{"v"}{Variance-covariance matrix of the estimate of the
sufficient statistics}
\item{"m"}{Estimate of the sufficient
statistics}
\item{"egor"}{The \code{\link[egor:egor]{egor}} object passed}
\item{"popsize"}{Population network size used}
\item{"ppopsize"}{Pseudopopulation size used, see \code{\link[=control.ergm.ego]{control.ergm.ego()}}}
\item{"coef"}{The
coefficients, along with the network size adjustment \code{netsize.adj}
coefficient.}
\item{"covar"}{Pseudo-MLE estimate of the
variance-covariance matrix of the parameter estimates under repeated
egocentric sampling}
\item{"ergm.covar"}{ The variance-covariance matrix of
parameter estimates under the ERGM superpopulation process (without
incorporating sampling).  }
\item{"DtDe"}{Estimated Jacobian of the expectation of the sufficient
statistics with respect to the model parameters}
}
\description{
A wrapper around the \code{\link[ergm:ergm]{ergm()}} to fit an ERGM to an
\code{\link[egor:egor]{egor}}.
}
\examples{
\donttest{
data(faux.mesa.high)
fmh.ego <- as.egor(faux.mesa.high)

head(fmh.ego)

egofit <- ergm.ego(fmh.ego~edges+degree(0:3)+nodefactor("Race")+nodematch("Race")
                         +nodefactor("Sex")+nodematch("Sex")+absdiff("Grade")+gwesp(0,fix=TRUE), 
                          popsize=network.size(faux.mesa.high))

# Run convergence diagnostics
mcmc.diagnostics(egofit)

# Estimates and standard errors
summary(egofit)
}

}
\references{
Pavel N. Krivitsky and Martina Morris (2017). "Inference for social network models from egocentrically sampled data, with application to understanding persistent racial disparities in HIV prevalence in the US." \emph{Annals of Applied Statistics}, 11(1): 427–455. \doi{10.1214/16-AOAS1010}

Pavel N. Krivitsky, Martina Morris, and Michał Bojanowski (2019). "Inference for Exponential-Family Random Graph Models from Egocentrically-Sampled Data with Alter–Alter Relations." NIASRA Working Paper 08-19. \url{https://www.uow.edu.au/niasra/publications/}

Pavel N. Krivitsky, Michał Bojanowski, and Martina Morris (2020). "Impact of survey design on estimation of exponential-family random graph models from egocentrically-sampled data." \emph{Social Networks}, to appear. \doi{10.1016/j.socnet.2020.10.001}

Pavel N. Krivitsky, Mark S. Handcock, and Martina Morris (2011). "Adjusting for
Network Size and Composition Effects in Exponential-Family Random Graph
Models." \emph{Statistical Methodology}, 8(4): 319–339. \doi{10.1016/j.stamet.2011.01.005}
}
\seealso{
\code{\link[ergm:ergm]{ergm()}}
}
\author{
Pavel N. Krivitsky
}
\keyword{models}
