\name{NEWS}
\title{NEWS file for the \code{\link[=ergm-package]{ergm}} package}
\encoding{UTF-8}

\section{Changes in version 3.0-2}{
  \subsection{NOTE}{
    \itemize{
      \item This is a technical bugfix release. There are no user-visible
      changes or changes in package behavior.
    }
  }

  \subsection{DEPRECATED & DEFUNCT}{
    \itemize{
      
      \item Suggestion dependency on
      \code{\link[=latentnet-package]{latentnet}} has been removed.
      
      \item Parallel computing with PVM (via \code{rpvm}) has been
      removed, since the package in question is no longer maintained.
      
    }
  }

  \subsection{BUG FIXES}{
    \itemize{
      \item A variety of fixes have been applied to make the package
      comply with more stringent package standards. In particular,
      \code{ergm.update.formula} no longer uses the ``forbidden''
      \code{.Internal()} call.

      \item A number of miscellaneous \code{R CMD check} warnings have
      been addressed.

      \item Some nonstandard behavior exposed by changes in
      \code{R-devel} has been addressed.

      \item Some parallel capabilities had to be disabled in 3.0-1 due
      to \R's handling of package environments. They have been reenabled.
    }
  }
}


\section{Changes in version 3.0-1}{
 
  \subsection{NEW FEATURES}{
    \itemize{
      \item Facilities for fitting and simulating Separable Temporal
      ERGMs (STERGMs) of Krivitsky (2009) and, Krivitsky and Handcock
      (2010) have been added. See \code{\link{stergm}} and
      \code{\link[=simulate.network]{smulate}}.
      
      \item \code{\link{ergm}} MCMLE will now test if the optimization
      has converged to the MLE and stop if it detects convergence.

      \item \code{\link{ergm}} Now checks if a constraint specified in
      the \code{constraints} argument fixes any statistics in the
      model (e.g., \code{ergm(y~edges, constraints=~edges)}). It issues a
      warning, and fixes their parameters at 0.

      \item \code{\link{simulate}} functions now take an argument
      \code{monitor}, a one-sided formula for additional statistics to
      be returned. This allows one to easily simulate from an
      \code{\link{ergm}} or \code{\link{stergm}} fit statistics that
      were not in the fitted model.

      \item \code{\link{ergm}} can now optionally detect when a burn-in
      is insufficient and retry it until it is sufficient. See
      \code{\link{control.ergm}} argument \code{MCMC.burnin.retries} for
      details.

      \item \code{\link{ergm}} MCMLE now stores "history" of
      \eqn{\theta} and simulated statistics.

      \item \code{\link{ergm}} extreme statistics detection (if
      \code{control.ergm(drop=TRUE)}) can now detect both extremely high
      and extremely low values, setting the coefficients to +Inf and
      -Inf respectively. Direction of "dropping" is retruned.

      \item An initial method \code{"zeros"} has been, to use a vector
      of zeros as starting parameters.

      \item A number of new ERGM terms have been added.
      
    }
  }
  
  \subsection{OTHER USER-VISIBLE CHANGES}{
    \itemize{
      \item \code{\link{ergm}}, \code{\link[=simulate.ergm]{simulate}},
      and other functions now enforce a conceptual separation between
      \emph{what} to fit, which is controlled by arguments to the
      function and \emph{how} to fit it, which is controlled by the
      \code{control} lists, generated by \code{\link{control.ergm}} and
      \code{\link{control.simulate}}, respectively. (Old arguments for
      \code{ergm} and \code{simulate} still work with a warning, and
      they may be removed later.)
      
      \item The data structure returned by
      \code{\link[=simulate.ergm]{simulate}} is now a list of networks
      with \code{\link{attr}}-style attributes describing how it was
      generated. The list has print and summary methods, and it can be
      used in the left-hand side of a
      \code{\link[=summary.formula]{summary}} formula.

      \item Matrices of sample statistics returned by \code{\link{ergm}}
      are \code{\link[coda]{mcmc}} objects (or
      \code{\link[coda]{mcmc.list}} objects, for parallel computing).
      
      \item Arguments \code{theta} have been renamed to
      \code{coef}. Arguments \code{meanstats} have been renamed to
      \code{target.stats}. Many control parameters have also been
      renamed and reorganized. (Old parameters still work with a
      warning, and they may be removed later.)
      
      \item A number of arguments to \code{\link{control.ergm}},
      \code{\link{control.simulate}}, and others, have been renamed.

      \item \code{\link{ergm}} now uses bridge sampling evaluate the
      log-likelihood by default. (Before, the default was to not
      evaluate it.)

      \item \code{\link[=mcmc.diagnostics]{mcmc.diagnostics}} has been
      rewritten:
      \itemize{
	\item Raftery-Lewis diagnostic has been  replaced with several
	others, including tests of (non)convergence.
	\item For fits with missing data, diagnostics for both the
	constrained and the unconstrained sample are printed and plotted.
	\item Plots now use \code{\link{lattice}} graphics, if available.
      }

      \item Handling of networks with many edges has been improved somewhat.
    }
  }
  \subsection{DEPRECATED & DEFUNCT}{
    \itemize{
      \item The following control parameters have been removed or
      renamed:
      \code{maxedges}, \code{prop.weights}, \code{prop.args},
      \code{packagename}, \code{summarizestats},    \code{nr.maxit},
      \code{nr.reltol}, \code{maxNumDyadTypes}, \code{maxedges},
      \code{steplength}, \code{initialfit}, \code{style},
      \code{obs.MCMCsamplesize}, \code{obs.interval}, \code{obs.burnin},
      \code{compress}, \code{metric}, \code{force.mcmc},
      \code{adaptive.trustregion}, \code{adaptive.epsilon},
      \code{mcmc.precision}, \code{method}, \code{MPLEtype},
      \code{check.degeneracy}, \code{maxMPLEsamplesize},
      \code{MPLEsamplesize}, \code{phase1_n}, \code{nsubphases},
      \code{RobMon.phase1n_base}, \code{RobMon.phase2n_base},
      \code{RobMon.phase2sub}, \code{RobMon.init_gain},
      \code{RobMon.phase3n}, \code{trustregion}, \code{stepMCMCsize},
      \code{steppingmaxit}, \code{gridsize}, \code{sequential},
      \code{returnMCMCstats}, \code{calc.mcmc.se}, \code{hessian},
      \code{prop.weights}, \code{prop.args}, and \code{packagenames}.
    
      \item The following arguments to functions have been moved to the
      corresponding control functions, removed or renamed:
      \code{burnin}, \code{MCMCsamplesize}, \code{interval},
      \code{maxit}, \code{seed}, and \code{theta0}.
    }
  }

  \subsection{BUG FIXES}{
    \itemize{
      \item Fixed some errors in log-likelihood calculation, especially
      in models with missing data and/or offset terms.

      \item Parallel processing has been made more robust. In
      particular, \code{\link[=ergm-package]{ergm}} now checks to make
      sure that the version it finds on slave nodes is the same as the
      version on the master. Also, although \code{\link{ergm}} will
      start its own cluster as needed, it will also detect if an MPI
      cluster has already been started and use that.

      \item Several bugs relating to handling models with with offset
      terms have been fixed.

      \item Miscellaneous robustification and bug fixes.
    }
  }
}

\section{Changes in version 2.4}{
  \subsection{NEW FEATURES}{
    \itemize{
      \item The "news" feature has been implemented. Type
  \code{news(package="ergm")} to see the version's updates.
      
      \item A function \code{\link{ergm.allstats}} was added to
      calculate all possible network statistics for a given ERGM and
      network. The number of possible networks grows on the order of \eqn{2^{n^2}}, so this should only be used for small networks.  Related function \code{\link{ergm.exact}} calculates exact log-likelihood for a particular canonical parameter and a particular ergm.

      \item A \code{cutoff} argument has been added to specify maximum shared partner
      count or degree to be evaluated to the following model terms:
      \code{\link{gwb1degree}}, \code{\link{gwb2degree}}, \code{\link{gwdegree}}, \code{\link{gwdsp}}, \code{\link{gwesp}}, \code{\link{gwidegree}}, \code{\link{gwnsp}},
      \code{\link{gwodegree}}. This significantly speeds up fitting
      curved ERGMs on large, sparse networks.

      \item The \code{\link{logLik}} method for
      \code{\link{ergm}} objects, with the attendant \code{\link{AIC}}
      and \code{\link{BIC}} methods, has been implemented.

      \item Calculation of loglikelihoods for MCMC-based ergm fits has
      been reengineered to use bridge sampling for dyad-dependent
      models. (See \code{\link{logLik.ergm}},
      \code{\link{ergm.bridge.llr}}, and
      \code{\link{ergm.bridge.dindstart.llk}}.)

      \item A generic function \code{\link{is.dyad.independent}} to test
      whether an ERGM fit or formula is dyad-independent has been added.
      
      \item A generic function \code{\link{fix.curved}} to convert
      curved exponential family models to variants in which the curved
      parameters are fixed has been added. See the function
      documentation for usage scenarios.

      \item A generic function \code{\link{enformulate}} function to
      work around a current limitation in the \code{\link{ergm}}
      function to substitute curved parameters from a model fit into the
      model formula, allowing them to be used as initial values (the
      \code{theta0} argument). See the function documentation for usage
      scenarios.

      \item The following new models terms have been added:  \code{\link{degcrossprod}} and \code{\link{degcor}}.
  
      \item For version 2.4-3, a new dataset has been added:  \code{\link{kapferer}}, the well-known
      tailor shop network dataset of Kapferer (1972).
    }
  }

  \subsection{BUG FIXES}{
    \itemize{
      \item Log-likelihood calculation for dyad-dependent models has
    been fixed.

      \item Some errors in estimating parameters in curved exponential
      family models have been fixed.

      \item \code{\link[=gof.ergm]{gof}} now automatically selects the
      right goodness-of-fit statistics for the network type (directed
      vs. undirected) given.
      
      \item Bug in is.inCH in 2.4-2 fixed in 2.4-3.
    }
  }
}
