% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.ergm.R
\name{gof}
\alias{gof}
\alias{gof.default}
\alias{gof.ergm}
\alias{gof.formula}
\alias{print.gof}
\alias{plot.gof}
\title{Conduct Goodness-of-Fit Diagnostics on a Exponential Family Random Graph
Model}
\usage{
gof(object, ...)

\method{gof}{ergm}(
  object,
  ...,
  coef = NULL,
  GOF = NULL,
  constraints = NULL,
  control = control.gof.ergm(),
  verbose = FALSE
)

\method{gof}{formula}(
  object,
  ...,
  coef = NULL,
  GOF = NULL,
  constraints = ~.,
  control = NULL,
  unconditional = TRUE,
  verbose = FALSE
)

\method{print}{gof}(x, ...)

\method{plot}{gof}(
  x,
  ...,
  cex.axis = 0.7,
  plotlogodds = FALSE,
  main = "Goodness-of-fit diagnostics",
  normalize.reachability = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{object}{Either a formula or an \code{\link{ergm}} object.
See documentation for \code{\link{ergm}}.}

\item{\dots}{Additional arguments, to be passed to lower-level functions.}

\item{coef}{When given either a formula or an object of class ergm,
\code{coef} are the parameters from which the sample is drawn. By default
set to a vector of 0.}

\item{GOF}{formula; an formula object, of the form \code{~ <model terms>}
specifying the statistics to use to diagnosis the goodness-of-fit of the
model.  They do not need to be in the model formula specified in
\code{formula}, and typically are not.  Currently supported terms are the
degree distribution (\dQuote{degree} for undirected graphs, or
\dQuote{idegree} and/or \dQuote{odegree} for directed graphs), geodesic
distances (\dQuote{distance}), shared partner distributions
(\dQuote{espartners} and \dQuote{dspartners}), the triad census
(\dQuote{triadcensus}), and the terms of the original model
(\dQuote{model}). The default formula for undirected networks is \code{~
degree + espartners + distance + model}, and the default formula for
directed networks is \code{~ idegree + odegree + espartners + distance +
model}.  By default a \dQuote{model} term is added to the formula.  It is a
very useful overall validity check and a reminder of the statistical
variation in the estimates of the mean value parameters.  To omit the
\dQuote{model} term, add \dQuote{- model} to the formula.}

\item{constraints}{A one-sided formula specifying one or more constraints on
the support of the distribution of the networks being modeled. See the help
for similarly-named argument in \code{\link{ergm}} for more information. For
\code{gof.formula}, defaults to unconstrained. For \code{gof.ergm}, defaults
to the constraints with which \code{object} was fitted.}

\item{control}{A list to control parameters, constructed using
\code{\link{control.gof.formula}} or \code{\link{control.gof.ergm}} (which
have different defaults).}

\item{verbose}{Provide verbose information on the progress of the
simulation.}

\item{unconditional}{logical; if \code{TRUE}, the simulation is
unconditional on the observed dyads.  if not \code{TRUE}, the simulation is
conditional on the observed dyads. This is primarily used internally when
the network has missing data and a conditional GoF is produced.}

\item{x}{an object of class \code{gof} for printing or plotting.}

\item{cex.axis}{Character expansion of the axis labels relative to that for
the plot.}

\item{plotlogodds}{Plot the odds of a dyad having given characteristics
(e.g., reachability, minimum geodesic distance, shared partners). This is an
alternative to the probability of a dyad having the same property.}

\item{main}{Title for the goodness-of-fit plots.}

\item{normalize.reachability}{Should the reachability proportion be
normalized to make it more comparable with the other geodesic distance
proportions.}
}
\value{
\code{\link{gof}}, \code{\link{gof.ergm}}, and
\code{\link{gof.formula}} return an object of class \code{gof.ergm}, which inherits from class \code{gof}.  This
is a list of the tables of statistics and \eqn{p}-values.  This is typically
plotted using \code{\link{plot.gof}}.
}
\description{
\code{\link{gof}} calculates \eqn{p}-values for geodesic distance, degree,
and reachability summaries to diagnose the goodness-of-fit of exponential
family random graph models.  See \code{\link{ergm}} for more information on
these models.
}
\details{
A sample of graphs is randomly drawn from the specified model.  The first
argument is typically the output of a call to \code{\link{ergm}} and the
model used for that call is the one fit.

For \code{GOF = ~model}, the model's observed sufficient statistics are
plotted as quantiles of the simulated sample. In a good fit, the observed
statistics should be near the sample median (0.5).

By default, the sample consists of 100 simulated networks, but this sample
size (and many other settings) can be changed using the \code{control}
argument described above.
}
\section{Methods (by class)}{
\itemize{
\item \code{ergm}: Perform simulation to evaluate goodness-of-fit for
a specific \code{\link[=ergm]{ergm()}} fit.

\item \code{formula}: Perform simulation to evaluate goodness-of-fit for
a model configuration specified by a \code{\link{formula}}, coefficient,
constraints, and other settings.

\item \code{gof}: \code{\link{print.gof}} summaries the diagnostics such as the
degree distribution, geodesic distances, shared partner
distributions, and reachability for the goodness-of-fit of
exponential family random graph models.  See \code{\link{ergm}} for
more information on these models. (\code{summary.gof} is a deprecated
alias that may be repurposed in the future.)

\item \code{gof}: \code{\link{plot.gof}} plots diagnostics such as the degree
distribution, geodesic distances, shared partner distributions, and
reachability for the goodness-of-fit of exponential family random graph
models.  See \code{\link{ergm}} for more information on these models.
}}

\note{
For \code{gof.ergm} and \code{gof.formula}, default behavior depends on the
directedness of the network involved; if undirected then degree, espartners,
and distance are used as default properties to examine.  If the network in
question is directed, \dQuote{degree} in the above is replaced by idegree
and odegree.
}
\examples{

\donttest{
data(florentine)
gest <- ergm(flomarriage ~ edges + kstar(2))
gest
summary(gest)

# test the gof.ergm function
gofflo <- gof(gest)
gofflo

# Plot all three on the same page
# with nice margins
par(mfrow=c(1,3))
par(oma=c(0.5,2,1,0.5))
plot(gofflo)

# And now the log-odds
plot(gofflo, plotlogodds=TRUE)

# Use the formula version of gof
gofflo2 <-gof(flomarriage ~ edges + kstar(2), coef=c(-1.6339, 0.0049))
plot(gofflo2)
}

}
\seealso{
\code{\link[=ergm]{ergm()}}, \code{\link[=network]{network()}}, \code{\link[=simulate.ergm]{simulate.ergm()}}, \code{\link[=summary.ergm]{summary.ergm()}}
}
\keyword{graphs}
\keyword{models}
