% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R, R/InitWtErgmTerm.R
\name{receiver-ergmTerm}
\alias{receiver-ergmTerm}
\alias{InitErgmTerm.receiver}
\alias{InitWtErgmTerm.receiver}
\title{Receiver effect}
\usage{
# binary: receiver(base=1, nodes=-1)

# valued: receiver(base=1, nodes=-1, form="sum")
}
\arguments{
\item{base}{deprecated}

\item{nodes}{specify which nodes' statistics should be included or excluded (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details)}

\item{form}{character how to aggregate tie values in a valued ERGM}
}
\description{
This term adds one network statistic for each node equal to the number of
in-ties for that node. This measures the popularity of the node. The term
for the first node is omitted by default because of linear dependence that
arises if this term is used together with \code{edges} , but its coefficient
can be computed as the negative of the sum of the coefficients of all the
other actors. That is, the average coefficient is zero, following the
Holland-Leinhardt parametrization of the $p_1$ model (Holland and Leinhardt,
1981).  This
term can only be used with directed networks. For undirected networks, see
\code{sociality} .
}
\note{
The argument \code{base} is retained for backwards compatibility and may be
removed in a future version. When both \code{base} and \code{nodes} are passed,
\code{nodes} overrides \code{base}.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.
}
\concept{directed}
\concept{dyad-independent}
