% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm-terms-index.R
\name{search.ergmReferences}
\alias{search.ergmReferences}
\title{Search the ERGM References}
\usage{
search.ergmReferences(search, keywords, name, packages)
}
\arguments{
\item{search}{optional character search term to search for in the text of the
term descriptions. Only matching terms will be returned. Matching is case
insensitive.}

\item{keywords}{optional character vector of keyword tags to use to
restrict the results (i.e. 'curved', 'triad-related')}

\item{name}{optional character name of a specific term to return}

\item{packages}{optional character vector indicating the subset of packages in which to search}
}
\value{
prints out the name and short description of matching terms, and
invisibly returns them as a list.  If \code{name} is specified, prints out
the full definition for the named term.
}
\description{
Searches through the \code{\link{ergm.references}} help page and prints out a
list of terms appropriate for the specified network's structural
constraints, optionally restricting by additional keywords and search term
matches.
}
\details{
Uses \code{\link{grep}} internally to match the search terms against the term
description, so \code{search} is currently matched as a single phrase.
Keyword tags will only return a match if all of the specified tags are
included in the term.
}
\examples{
\donttest{
# find all of the references that mention dyad
search.ergmReferences('dyad')

# search on multiple keywords
search.ergmReferences(keywords=c('binary','discrete'))

# print out the content for a specific reference
search.ergmReferences(name='Bernoulli')

# request the bipartite keyword in the ergm package
search.ergmReferences(keywords='binary', packages='ergm')
}
}
\seealso{
See also \code{\link{ergm.references}} for the complete documentation
}
\author{
skyebend@uw.edu
}
