% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{b1degree-ergmTerm}
\alias{b1degree-ergmTerm}
\alias{InitErgmTerm.b1degree}
\title{Degree for the first mode in a bipartite network}
\usage{
# binary: b1degree(d, by=NULL, levels=NULL)
}
\arguments{
\item{d}{a vector of distinct integers.}

\item{by}{a vertex attribute (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details). If this is specified
then each node's degree is tabulated only with other nodes having the same
value of the \code{by} attribute.}

\item{levels}{TODO (See Specifying Vertex
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}
}
\description{
This term adds one network statistic to the model for
each element in \code{d} ; the \eqn{i}th such statistic equals the number of
nodes of degree \code{d[i]} in the first mode of a bipartite network, i.e.
with exactly \code{d[i]} edges. The first mode of a bipartite network object
is sometimes known as the "actor" mode.
}
\note{
This term can only be used with undirected bipartite networks.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "b1degree", "subsection")}
}
\concept{bipartite}
\concept{categorical nodal attribute}
\concept{frequently-used}
\concept{undirected}
