% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel.utils.R
\name{ergm-parallel}
\alias{ergm-parallel}
\alias{parallel}
\alias{ergm.parallel}
\alias{parallel.ergm}
\alias{parallel-ergm}
\alias{ergm.getCluster}
\alias{ergm.stopCluster}
\alias{ergm.restartCluster}
\alias{set.MT_terms}
\alias{get.MT_terms}
\alias{nthreads}
\alias{nthreads.cluster}
\alias{nthreads.NULL}
\alias{nthreads.control.list}
\title{Parallel Processing in the \code{ergm} Package}
\usage{
ergm.getCluster(control = NULL, verbose = FALSE, stop_on_exit = parent.frame())

ergm.stopCluster(..., verbose = FALSE)

ergm.restartCluster(control = NULL, verbose = FALSE)

set.MT_terms(n)

get.MT_terms()

nthreads(clinfo = NULL, ...)

\method{nthreads}{cluster}(clinfo = NULL, ...)

\method{nthreads}{`NULL`}(clinfo = NULL, ...)

\method{nthreads}{control.list}(clinfo = NULL, ...)
}
\arguments{
\item{control}{a \code{\link[=control.ergm]{control.ergm()}} (or similar) list of
parameter values from which the parallel settings should be read;
can also be \code{\link{NULL}}, in which case an existing cluster is used
if started, or no cluster otherwise.}

\item{verbose}{A logical or an integer to control the amount of
progress and diagnostic information to be printed. \code{FALSE}/\code{0}
produces minimal output, with higher values producing more
detail. Note that very high values (5+) may significantly slow
down processing.}

\item{stop_on_exit}{An \code{\link{environment}} or \code{NULL}. If an
\code{environment}, defaulting to that of the calling function, the
cluster will be stopped when the calling the frame in question
exits.}

\item{\dots}{not currently used}

\item{n}{an integer specifying the number of threads to use; 0 (the
starting value) disables multithreading, and \eqn{-1} or
\code{NA} sets it to the number of CPUs detected.}

\item{clinfo}{a \code{\link[parallel:makeCluster]{cluster}} or another object.}
}
\value{
\code{\link[=set.MT_terms]{set.MT_terms()}} returns the previous setting, invisibly.

\code{\link[=get.MT_terms]{get.MT_terms()}} returns the current setting.
}
\description{
Using clusters multiple CPUs or CPU cores to speed up ERGM
estimation and simulation.

The \code{ergm.getCluster} function is usually called
internally by the ergm process (in
\code{\link[=ergm_MCMC_sample]{ergm_MCMC_sample()}}) and will attempt to start the
appropriate type of cluster indicated by the
\code{\link[=control.ergm]{control.ergm()}} settings. It will also check that the
same version of \code{ergm} is installed on each node.

The \code{ergm.stopCluster} shuts down a
cluster, but only if \code{ergm.getCluster} was responsible for
starting it.

The \code{ergm.restartCluster} restarts and returns a cluster,
but only if \code{ergm.getCluster} was responsible for starting it.

\code{nthreads} is a simple generic to obtain the number of
parallel processes represented by its argument, keeping in mind
that having no cluster (e.g., \code{NULL}) represents one thread.
}
\details{
For estimation that require MCMC, \link[=ergm-package]{ergm} can take
advantage of multiple CPUs or CPU cores on the system on which it
runs, as well as computing clusters through one of two mechanisms:

\describe{\item{Running MCMC chains in parallel}{ Packages
\code{parallel} and \code{snow} are used to to facilitate this, all cluster
types that they support are supported.

The number of nodes used and the parallel API are controlled using
the \code{parallel} and \code{parallel.type} arguments passed to the control
functions, such as \code{\link[=control.ergm]{control.ergm()}}.

The \code{\link[=ergm.getCluster]{ergm.getCluster()}} function is usually called internally by
the ergm process (in \code{\link[=ergm_MCMC_sample]{ergm_MCMC_sample()}}) and will attempt to
start the appropriate type of cluster indicated by the
\code{\link[=control.ergm]{control.ergm()}} settings. The \code{\link[=ergm.stopCluster]{ergm.stopCluster()}} is helpful if
the user has directly created a cluster.

Further details on the various cluster types are included below.}

\item{Multithreaded evaluation of model terms}{ Rather than running
multiple MCMC chains, it is possible to attempt to accelerate
sampling by evaluating qualified terms' change statistics in
multiple threads run in parallel. This is done using the
\href{https://www.openmp.org/}{OpenMP} API.

However, this introduces a nontrivial amont of computational
overhead. See below for a list of the major factors affecting
whether it is worthwhile.}}

Generally, the two approaches should not be used at the same time
without caution. In particular, by default, cluster slave nodes
will not \dQuote{inherit} the multithreading setting; but
\verb{parallel.inherit.MT=} control parameter can override that. Their
relative advantages and disadvantages are as follows:
\itemize{
\item Multithreading terms cannot take advantage of clusters but only
of CPUs and cores.
\item Parallel MCMC chains produce several independent chains;
multithreading still only produces one.
\item Multithreading terms actually accellerates sampling, including
the burn-in phase; parallel MCMC's multiple burn-in runs are
effectively \dQuote{wasted}.
}
}
\note{
The this is a setting global to the \code{ergm} package and all of
its C functions, including when called from other packages via
the \code{Linking-To} mechanism.
}
\section{Different types of clusters}{


\describe{\item{PSOCK clusters}{ The \code{parallel} package is used with PSOCK clusters
by default, to utilize multiple cores on a system. The number of
cores on a system can be determined with the \code{\link[=detectCores]{detectCores()}}
function.

This method works with the base installation of R on all platforms,
and does not require additional software.

For more advanced applications, such as clusters that span multiple
machines on a network, the clusters can be initialized manually,
and passed into \code{\link[=ergm]{ergm()}} and others using the \code{parallel} control
argument. See the second example below.}

\item{MPI clusters}{ To use MPI to accelerate ERGM sampling,
pass the control parameter \code{parallel.type="MPI"}.
\link[=ergm-package]{ergm} requires the \CRANpkg{snow} and \CRANpkg{Rmpi} packages to
communicate with an MPI cluster.

Using MPI clusters requires the system to have an existing MPI
installation.  See the MPI documentation for your particular
platform for instructions.

To use \code{\link[=ergm]{ergm()}} across multiple machines in a high performance
computing environment, see the section "User initiated clusters"
below.}

\item{User initiated clusters}{ A cluster can be passed into \code{\link[=ergm]{ergm()}}
with the \code{parallel} control parameter. \code{\link[=ergm]{ergm()}} will detect the
number of nodes in the cluster, and use all of them for MCMC
sampling. This method is flexible: it will accept any cluster type
that is compatible with \code{snow} or \code{parallel} packages.
}}
}

\section{When is multithreading terms worthwhile?}{

\itemize{
\item The more terms with statistics the model has, the more
benefit from parallel execution.
\item The more expensive the terms in the model are, the more benefit
from parallel execution. For example, models with terms like
\code{\link[=gwdsp-ergmTerm]{gwdsp}} will generally get more benefit than models where all
terms are dyad-independent.
\item Sampling more dense networks will generally get more benefit than
sparse networks. Network size has little, if any, effect.
\item More CPUs/cores usually give greater speed-up, but only up to a
point, because the amount of overhead grows with the number of
threads; it is often better to \dQuote{batch} the terms into a smaller
number of threads than possible.
\item Any other workload on the system will have a more severe effect
on multithreaded execution. In particular, do not run more
threads than CPUs/cores that you want to allocate to the tasks.
\item Under Windows, even compiling with OpenMP appears to introduce
unacceptable amounts of overhead, so it is disabled for Windows
at compile time. To enable, \emph{delete} \code{src/Makevars.win} and
recompile from scratch.
}
}

\examples{

\donttest{
# Uses 2 SOCK clusters for MCMLE estimation
data(faux.mesa.high)
nw <- faux.mesa.high
fauxmodel.01 <- ergm(nw ~ edges + isolates + gwesp(0.2, fixed=TRUE), 
                     control=control.ergm(parallel=2, parallel.type="PSOCK"))
summary(fauxmodel.01)

}

}
