% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm-package.R
\name{ergmHint}
\alias{ergmHint}
\alias{ergm-hints}
\alias{hints-ergm}
\alias{ergm.hints}
\alias{hints.ergm}
\alias{hints}
\title{MCMC Hints for Exponential-Family Random Graph Models}
\description{
This page describes how to provide to the
\CRANpkg{ergm}'s MCMC algorithms information about the sample space. Hints can also be searched via \code{\link{search.ergmHints}}, and help for an individual hint can be obtained with \verb{ergmHint?<hint>} or \code{help("<hint>-ergmHint")}.
}
\section{\dQuote{Hints} for MCMC}{

\ERGMspec

\newcommand{\Hint}{\dQuote{Hint}}
\newcommand{\hint}{\dQuote{hint}}
\newcommand{\Hints}{\dQuote{Hints}}
\newcommand{\hints}{\dQuote{hints}}

It is often the case that there is additional information available
about the distribution of networks being modelled. For example, you
may be aware that the network is sparse or that there are strata
among the dyads. \Hints, typically passed on the right-hand side of \code{MCMC.prop}
and \code{obs.MCMC.prop} arguments to \code{\link[=control.ergm]{control.ergm()}},
\code{\link[=control.simulate.ergm]{control.simulate.ergm()}}, and others, allow this information to be
provided. By default, hint \code{\link[=sparse-ergmHint]{sparse}} is in
effect.

Unlike constraints, model terms, and reference distributions,
\hints{} do not affect the specification of the model. That is,
regardless of what \hints{} may or may not be in effect, the sample
space and the probabilities within it are the same. However,
\hints{} may affect the MCMC proposal distribution used by the
samplers.

Note that not all proposals support all \hints: and if the most
suitable proposal available cannot incorporate a particular \hint,
a warning message will be printed.

\Hints{} use the same underlying API as constraints, and, if present,
\code{\link{\%ergmlhs\%}} attributes \code{constraints} and \code{constraints.obs} will
be substituted in its place.
}

\section{Hints available to the package}{


The following hints are known to \CRANpkg{ergm} at this time:

\ergmCSS

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexLatex(ergm:::.buildTermsDataframe("ergmHint"))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexText(ergm:::.buildTermsDataframe("ergmHint"))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexHtml(ergm:::.buildTermsDataframe("ergmHint"))}}
}

\references{
\itemize{
\item Goodreau SM, Handcock MS, Hunter DR, Butts CT, Morris M (2008a).  A
\CRANpkg{statnet} Tutorial. \emph{Journal of Statistical Software}, 24(8).
\doi{10.18637/jss.v024.i08}
\item Hunter, D. R. and Handcock, M. S. (2006) \emph{Inference in curved
exponential family models for networks}, Journal of Computational and
Graphical Statistics.
\item Hunter DR, Handcock MS, Butts CT, Goodreau SM, Morris M (2008b).
\CRANpkg{ergm}: A Package to Fit, Simulate and Diagnose Exponential-Family
Models for Networks.  \emph{Journal of Statistical Software}, 24(3).
\doi{10.18637/jss.v024.i03}
\item Karwa V, Krivitsky PN, and Slavkovi\'c AB (2016). Sharing Social Network
Data: Differentially Private Estimation of Exponential-Family Random Graph
Models. \emph{Journal of the Royal Statistical Society, Series C}, 66(3):
481-500. \doi{10.1111/rssc.12185}
\item Krivitsky PN (2012). Exponential-Family Random Graph Models for Valued
Networks. \emph{Electronic Journal of Statistics}, 6, 1100-1128.
\doi{10.1214/12-EJS696}
\item Morris M, Handcock MS, Hunter DR (2008).  Specification of
Exponential-Family Random Graph Models: Terms and Computational Aspects.
\emph{Journal of Statistical Software}, 24(4). \doi{10.18637/jss.v024.i04}
}
}
\keyword{models}
