% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{new_rergmito}
\alias{new_rergmito}
\alias{[.ergmito_sampler}
\alias{print.ergmito_sampler}
\title{ERGMito sampler}
\usage{
new_rergmito(
  model,
  theta = NULL,
  sizes = NULL,
  cl = NULL,
  ncores = 1L,
  force = FALSE,
  ...
)

\method{[}{ergmito_sampler}(x, i, j, ...)

\method{print}{ergmito_sampler}(x, ...)
}
\arguments{
\item{model}{A formula.}

\item{theta}{Named vector. Model parameters.}

\item{sizes}{Integer vector. Values between 2 to 5 (6 becomes too intensive).}

\item{cl}{An object of class \link[parallel:makeCluster]{cluster}.}

\item{ncores}{Integer. Number of processors to use.}

\item{force}{Logical. When \code{FALSE} (default) will try to use \code{ergmito}'s stat
count functions (see \link{count_stats}). This means that if one of the requested
statistics in not available in \code{ergmito}, then we will use \code{ergm} to compute
them, which is significantly slower (see details).}

\item{...}{Further arguments passed to \link[ergm:ergm.allstats]{ergm::ergm.allstats}.}

\item{x}{An object of class \code{ergmito_sampler}.}

\item{i, j}{\code{i} is an integer vector indicating the indexes of the networks to
draw, while \code{j} the corresponding sizes. These need not to be of the same size.}
}
\value{
An environment with the following objects:
\itemize{
\item \code{calc_prob} A function to calculate each graph's probability under the
specified model.
\item \code{call} A language object with the call.
\item \code{counts} A list with 3 elements: \code{stats} the sufficient statistics of each network,
\code{weights} and \code{statmat} the overall matrices of sufficient statistics used to
compute the likelihood.
\item \code{network0} The baseline network used to either fit the model or obtain
attributes.
\item \code{networks} A list with the actual sample space of networks.
\item \code{prob} A numeric
\item \code{sample} A function to draw samples. \code{n} specifies the number of samples to
draw, \code{s} the size of the networks, and \code{theta} the parameter to use to
calculate the likelihoods.
\item \code{theta} Named numeric vector with the current values of the model parameters.
}

The indexing method \verb{[.ergmito_sampler} returns a named list of length
\code{length(j)}.
}
\description{
Create a sampler object that allows you simulating streams of small networks
fast.
}
\details{
While the \CRANpkg{ergm} package is very efficient, it was not built to do some
of the computations required in the ergmito package. This translates in having
some of the functions of the package (ergm) with poor speed performance. This
led us to "reinvent the wheel" in some cases to speed things up, this includes
calculating observed statistics in a list of networks.

The indexing method, \verb{[.ergmito_sampler}, allows extracting networks
directly by passing indexes. \code{i} indicates the index of the networks to draw,
which go from 1 through \code{2^(n*(n-1))}, and \code{j} indicates the requested
size.
}
\examples{

# We can generate a sampler from a random graph
set.seed(7131)
ans <- new_rergmito(rbernoulli(4) ~ edges)

# Five samples
ans$sample(5, s = 4)

# or we can use some nodal data:
data(fivenets)
ans <- new_rergmito(
  fivenets[[3]] ~ edges + nodematch("female"),
  theta = c(-1, 1)
)

# Five samples
ans$sample(5, s = 4) # All these networks have a "female" vertex attr

}
