% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.R
\name{check_types}
\alias{check_types}
\title{Check Each Item's Type}
\usage{
check_types(
  x,
  valid,
  name = NULL,
  general = NULL,
  specific = NULL,
  supplement = NULL,
  n = NULL,
  ...
)
}
\arguments{
\item{x}{The argument to check, which must be a list.}

\item{valid}{A character vector which contains the valid types.}

\item{name}{A single character which gives the argument's name.
The name is used in the error message. By default, the name of the
argument passed to argument \code{x} is captured automatically.}

\item{general}{Optional. A single character which is used to give a
general statement of the error incurred. By default, this is generated
automatically.}

\item{specific}{Optional. A single character which gives a detailed
description of the error. \code{\link[glue:glue]{glue::glue()}} syntax can be used, see
"Examples" section. By default, this is generated automatically.}

\item{supplement}{Optional. A (named) character vector which gives some
additional information about the error. The names are used to create
bullets, see \code{\link[=Statement]{Statement()}}. By default, this is left empty.}

\item{n}{Optional. A non-negative integer which indicates how many invalid
items at most to display. The default value is \code{5}.}

\item{...}{Optional. Additional arguments passed to \code{\link[rlang:abort]{rlang::abort()}},
which is called internally.}
}
\value{
An invisible \code{NULL} if the argument is valid, or an error message
is generated.
}
\description{
Check if each item of an argument has valid type,
and if not, generate an error message.
}
\examples{
\dontrun{
# argument to check
arg <- as.list(1:10)

check_types(arg, "character")

# customize error message with `glue::glue()` syntax
specific <- "`{name}[[{i}]]` is an {feature}, oh my god!"
check_types(arg, "character",  specific = specific)

# change the number of invalid items to display
check_types(arg, "character", n = 0)
}
}
\seealso{
"Examples" section in \code{\link[=check_type]{check_type()}} for how to customize
error message and how to add and retrieve additional arguments.

\code{vignette("erify")} for a gentle introduction to this package.
}
