% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ESA_BCV.R
\name{EsaBcv}
\alias{EsaBcv}
\title{Estimate Latent Factor Matrix}
\usage{
EsaBcv(Y, X = NULL, r.limit = 20, niter = 3, nRepeat = 12, only.r = F,
  svd.method = "fast", center = F)
}
\arguments{
\item{Y}{observed data matrix. p is the number of variables and
n is the sample size. Dimension is \code{c(n, p)}}

\item{X}{the known predictors of size \code{c(n, k)} if any. Default is NULL (no known predictors).
\code{k} is the number of known covariates.}

\item{r.limit}{the maximum number of factor to try. Default is 20.
Can be set to Inf.}

\item{niter}{the number of iterations for ESA. Default is 3.}

\item{nRepeat}{number of repeats of BCV. In other words, the random partition of \eqn{Y}
will be repeated for \code{nRepeat} times. Default is 12.}

\item{only.r}{whether only to estimate and return the number of factors.}

\item{svd.method}{either "fast", "propack" or "standard".
"fast" is using the \code{\link[corpcor]{fast.svd}} function in package corpcor to compute SVD, "propack" is using the \code{\link[svd]{propack.svd}} to compute SVD and "standard"
is using the \code{\link[base]{svd}} function in the base package. Because of PROPACK
issues, "propack" fails for some matrices, and when that happens,
the function will use "fast" to
compute the SVD of that matrix instead. Default method is "fast".}

\item{center}{logical, whether to center the data before factor analysis.
Default is False.}
}
\value{
\code{EsaBcv} returns an obejct of \code{\link[base]{class}} "esabcv"
The function \code{plot} plots the cross-validation results and points out the
number of factors estimated
An object of class "esabcv" is a list containing the following components:
  \item{best.r}{the best number of factor estimated}
  \item{estSigma}{the diagonal entries of estimated \eqn{\Sigma}
  which is a vector of length \code{p}}
  \item{estU}{the estimated \eqn{U}. Dimension is \code{c(n, r)}}
  \item{estD}{the estimated diagonal entries of \eqn{D}
  which is a vector of length \code{r}}
  \item{estV}{the estimated \eqn{V}. Dimension is \code{c(p, r)}}
  \item{beta}{the estimated \eqn{\beta} which is a matrix of size \code{c(k, p)}.
  Return NULL if the argument \code{X} is NULL.}
  \item{estS}{the estimated signal(factor) matrix \eqn{S} where
             \deqn{S = 1 \mu' + X \beta + n^{1/2}U D V'}}
  \item{mu}{the sample centers of each variable which is a vector of length
  \code{p}. It's an estimate of \eqn{\mu}. Return
  NULL if the argument \code{center} is False.}
  \item{max.r}{the actual maximum number of factors used. For the details of how this is decided,
  please refer to Owen and Wang (2015)}
  \item{result.list}{a matrix with dimension \code{c(nRepeat, (max.r + 1))} storing
  the detailed BCV entrywise MSE of each repeat for r from 0 to \code{max.r}}
}
\description{
Find out the best number of factors using Bi-Cross-Validation (BCV) with
Early-Stopping-Alternation (ESA) and then estimate the factor matrix.
}
\details{
The model is
\deqn{Y = 1 \mu' + X \beta + n^{1/2}U D V' + E \Sigma^{1/2}}
where \eqn{D} and \eqn{\Sigma} are diagonal matrices, \eqn{U} and \eqn{V}
are orthogonal and \eqn{mu'}
and \eqn{V'} represent _mu transposed_ and _V transposed_ respectively.
The entries of \eqn{E} are assumed to be i.i.d. standard Gaussian.
The model assumes heteroscedastic noises and especially works well for
high-dimensional data. The method is based on Owen and Wang (2015). A warning is that
when nonnull \code{X} is given or centering the data is required (which is essentially
adding a known covariate with all \eqn{1}), the method will first use linear regression
to estimate the coefficients of the known covariates, and then estimate the latent factors
from the residuals, whose low-rank part is actually the proportion of the latent factors
that are orthogonal to \code{X} minus the noises that are projected to \code{X}. Thus,
to make the residuals still low rank, \code{k} should be a small number. Even though the
latent factors estimated from the residuals will be biased, the estimate of the whole
signal (factor) matrix \code{S} will still be OK.
}
\examples{
Y <- matrix(rnorm(100), nrow = 10)
EsaBcv(Y)
}
\references{
Art B. Owen and Jingshu Wang(2015), Bi-cross-validation for factor analysis,
\url{http://de.arxiv.org/pdf/1503.03515}
}
\seealso{
\code{\link{ESA}}, \code{\link{plot.esabcv}}
}

