% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esc_bin_prop.R
\name{esc_bin_prop}
\alias{esc_bin_prop}
\title{Compute effect size from binary proportions}
\usage{
esc_bin_prop(prop1event, grp1n, prop2event, grp2n, es.type = c("logit", "d",
  "g", "or", "r", "cox.d"), study = NULL)
}
\arguments{
\item{prop1event}{Proportion of successes in treatment group (proportion of outcome = yes).}

\item{grp1n}{Treatment group sample size.}

\item{prop2event}{Proportion of successes in control group (proportion of outcome = yes).}

\item{grp2n}{Control group sample size.}

\item{es.type}{Type of effect size that should be returned.
\describe{
  \item{\code{"d"}}{returns standardized mean difference effect size \code{d}}
  \item{\code{"g"}}{returns adjusted standardized mean difference effect size Hedges' \code{g}}
  \item{\code{"or"}}{returns effect size as odds ratio}
  \item{\code{"cox.or"}}{returns effect size as Cox-odds ratio (see \code{\link{esc_d2or}} for details)}
  \item{\code{"logit"}}{returns effect size as log odds}
  \item{\code{"cox.log"}}{returns effect size as Cox-log odds (see \code{\link{esc_d2logit}} for details)}
  \item{\code{"r"}}{returns correlation effect size \code{r}}
}}

\item{study}{Optional string with the study name. Using \code{rbind} or
\code{as.data.frame} on \code{esc}-objects will add this as column
in the returned data frame.}
}
\value{
The effect size \code{es}, the standard error \code{se}, the variance
        of the effect size \code{var}, the lower and upper confidence limits
        \code{ci.lo} and \code{ci.hi}, the weight factor \code{w} and the
        total sample size \code{totaln}.
}
\description{
Compute effect size from binary proportions
}
\note{
If \code{es.type = "r"}, Fisher's transformation for the effect size
      \code{r} and their confidence intervals are also returned.
}
\examples{
# effect size log odds
esc_bin_prop(prop1event = .375, grp1n = 80, prop2event = .47, grp2n = 85)

# effect size odds ratio
esc_bin_prop(prop1event = .375, grp1n = 80, prop2event = .47, grp2n = 85,
             es.type = "or")

}
\references{
Lipsey MW, Wilson DB. 2001. Practical meta-analysis. Thousand Oaks, Calif: Sage Publications
            \cr \cr
            Wilson DB. 2016. Formulas Used by the "Practical Meta-Analysis Effect Size Calculator". Unpublished manuscript: George Mason University
}

