% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boin_selector.R
\name{get_boin}
\alias{get_boin}
\title{Get an object to fit the BOIN model using the BOIN package.}
\usage{
get_boin(num_doses, target, use_stopping_rule = TRUE, ...)
}
\arguments{
\item{num_doses}{Number of doses under investigation.}

\item{target}{We seek a dose with this probability of toxicity.}

\item{use_stopping_rule}{TRUE to use the toxicity stopping rule described in
Yan et al. (2019). FALSE to suppress the authors' stopping rule, with the
assumption being that you will test the necessity to stop early in some other
way.}

\item{...}{Extra args are passed to \code{\link[BOIN]{select.mtd}}.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit the
BOIN model to outcomes.
}
\description{
Get an object to fit the BOIN model using the BOIN package.
}
\examples{
target <- 0.25
model1 <- get_boin(num_doses = 5, target = target)

outcomes <- '1NNN 2NTN'
model1 \%>\% fit(outcomes) \%>\% recommended_dose()

}
\references{
Yan, F., Pan, H., Zhang, L., Liu, S., & Yuan, Y. (2019).
BOIN: An R Package for Designing Single-Agent and Drug-Combination
Dose-Finding Trials Using Bayesian Optimal Interval Designs.
Journal of Statistical Software, 27(November 2017), 0–35.
https://doi.org/10.18637/jss.v000.i00

Liu, S., & Yuan, Y. (2015).
Bayesian optimal designs for Phase I clinical trials.
J. R. Stat. Soc. C, 64, 507–523.
https://doi.org/10.1111/rssc.12089
}
