% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mdiff.R
\name{plot_pdiff}
\alias{plot_pdiff}
\title{Plots for comparing categorical outcome variables between conditions}
\usage{
plot_pdiff(
  estimate,
  error_layout = c("halfeye", "eye", "gradient", "none"),
  error_scale = 0.3,
  error_normalize = c("groups", "all", "panels"),
  difference_axis_breaks = 5,
  difference_axis_space = 1,
  simple_contrast_labels = TRUE,
  ylim = c(NA, NA),
  ybreaks = 5,
  rope = c(NA, NA),
  ggtheme = NULL
)
}
\arguments{
\item{estimate}{An esci-estimate object generated by an estimate_pdiff_
function}

\item{error_layout}{Optional; one of 'halfeye', 'eye', 'gradient' or 'none'
to determine how expected error distribution will be displayed for each
estimated parameter.  Defaults to 'halfeye'.  Currently does not apply
if 'median' is selected as effect size, in which case a simple error bar
will be used}

\item{error_scale}{Optional numeric determining width of the expected error
distribution.  Defaults to 0.3}

\item{error_normalize}{Optional; one of 'groups', 'all', or 'panels' to
determine how width of the expected error distributions will be normalized.
Defaults to 'groups'.  See documentation in ggdist}

\item{difference_axis_breaks}{Optional numeric > 1 of suggested number of breaks
for the difference axis.  Defaults to 5}

\item{difference_axis_space}{Optional numeric > 0 to indicate spacing to the
difference axis.  Defaults to 1}

\item{simple_contrast_labels}{Optional logical to determine if contrasts are
given simple labels ('Reference', 'Comparison', 'Difference') or more
descriptive labels based on the contrast specified.}

\item{ylim}{Optional 2-item vector specifying y-axis limits.  Defaults to
c(NA NA); Use NA to specify auto-limit.}

\item{ybreaks}{Optional numeric > 2 for suggested number of y-axis breaks;
defaults to 5}

\item{rope}{Optional 2-item vector with item 2 >= item 1.  Use to specify a range
of values to use to visualize a hypothesis test.  If both values are the
same, a point-null hypothesis test will be visualized.  If item2 > item1
an interval-null hypothesis test will be visualized.  Defaults to c(NA, NA),
which is to not visualize a hypothesis test}

\item{ggtheme}{Optional ggplot2 theme object to specify the visual style of the
plot.  Defaults to \code{\link[ggplot2:ggtheme]{ggplot2::theme_classic()}}}
}
\value{
Returns a ggplot object
}
\description{
\code{plot_pdiff} helps visualize comparisons of a categorical outcome
variable between conditions.  It plots proportions of cases for each
level of grouping variable and emphasizes a 1-df comparison among
conditions, plotting the estimated difference and its confidence interval
with a difference axis.  You can pass esci-estimate objects generated
by \code{\link[=estimate_pdiff_one]{estimate_pdiff_one()}}, \code{\link[=estimate_pdiff_two]{estimate_pdiff_two()}},
\code{\link[=estimate_pdiff_paired]{estimate_pdiff_paired()}}, \code{\link[=estimate_pdiff_ind_contrast]{estimate_pdiff_ind_contrast()}}
This function returns a ggplot2 object.
}
\details{
This function was developed primarily for student use within jamovi when
learning along with the text book Introduction to the New Statistics, 2nd
edition (Cumming & Calin-Jageman, 2024).

Expect breaking changes as this function is improved for general use.  Work
still do be done includes:
\itemize{
\item Revise to avoid deprecated ggplot features
\item Revise for consistent ability to control aesthetics and consistent
layer names
}
}
\examples{
data("data_campus_involvement")

estimate_from_raw <- esci::estimate_pdiff_two(
  esci::data_campus_involvement,
  CommuterStatus,
  Gender
)

# To visualize the estimate
myplot_from_raw <- esci::plot_pdiff(estimate_from_raw)

# To conduct a hypothesis test
res_htest_from_raw <- esci::test_pdiff(estimate_from_raw)


# From summary_data
estimate_from_summary <- esci::estimate_pdiff_two(
  comparison_cases = 10,
  comparison_n = 20,
  reference_cases = 78,
  reference_n = 252,
  grouping_variable_levels = c("Original", "Replication"),
  conf_level = 0.95
)

# To visualize the estimate
myplot_from_summary <- esci::plot_pdiff(estimate_from_summary)

#' # To conduct a hypothesis test
res_htest_from_summary <- esci::test_pdiff(estimate_from_summary)


}
