
# This file is automatically generated, you probably don't want to edit this

jamovimagnitudeOptions <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "jamovimagnitudeOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            switch = "from_raw",
            outcome_variable = NULL,
            mean = "",
            sd = "",
            n = "",
            outcome_variable_name = "Outcome variable",
            conf_level = 95,
            effect_size = "mean",
            show_details = FALSE,
            show_calculations = FALSE,
            evaluate_hypotheses = FALSE,
            null_value = "0",
            null_boundary = "0",
            alpha = 0.05,
            null_color = "#A40122",
            es_plot_width = "300",
            es_plot_height = "400",
            ymin = "auto",
            ymax = "auto",
            breaks = "auto",
            ylab = "auto",
            xlab = "auto",
            axis.text.y = "14",
            axis.title.y = "15",
            axis.text.x = "14",
            axis.title.x = "15",
            error_layout = "halfeye",
            error_scale = "0.20",
            error_nudge = "0.3",
            data_layout = "random",
            data_spread = "0.25",
            shape_raw = "circle filled",
            shape_summary = "circle filled",
            color_raw = "#008DF9",
            color_summary = "#008DF9",
            fill_raw = "NA",
            fill_summary = "#008DF9",
            size_raw = "2",
            size_summary = "4",
            alpha_raw = "1",
            alpha_summary = "1",
            linetype_summary = "solid",
            color_interval = "black",
            size_interval = "3",
            alpha_interval = "1",
            alpha_error = "1",
            fill_error = "gray75", ...) {

            super$initialize(
                package="esci",
                name="jamovimagnitude",
                requiresData=TRUE,
                ...)

            private$..switch <- jmvcore::OptionList$new(
                "switch",
                switch,
                default="from_raw",
                options=list(
                    "from_raw",
                    "from_summary"))
            private$..outcome_variable <- jmvcore::OptionVariables$new(
                "outcome_variable",
                outcome_variable,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "numeric"))
            private$..mean <- jmvcore::OptionString$new(
                "mean",
                mean,
                default="")
            private$..sd <- jmvcore::OptionString$new(
                "sd",
                sd,
                default="")
            private$..n <- jmvcore::OptionString$new(
                "n",
                n,
                default="")
            private$..outcome_variable_name <- jmvcore::OptionString$new(
                "outcome_variable_name",
                outcome_variable_name,
                default="Outcome variable")
            private$..conf_level <- jmvcore::OptionNumber$new(
                "conf_level",
                conf_level,
                default=95)
            private$..effect_size <- jmvcore::OptionList$new(
                "effect_size",
                effect_size,
                default="mean",
                options=list(
                    "mean",
                    "median"))
            private$..show_details <- jmvcore::OptionBool$new(
                "show_details",
                show_details,
                default=FALSE)
            private$..show_calculations <- jmvcore::OptionBool$new(
                "show_calculations",
                show_calculations,
                default=FALSE)
            private$..evaluate_hypotheses <- jmvcore::OptionBool$new(
                "evaluate_hypotheses",
                evaluate_hypotheses,
                default=FALSE)
            private$..null_value <- jmvcore::OptionString$new(
                "null_value",
                null_value,
                default="0")
            private$..null_boundary <- jmvcore::OptionString$new(
                "null_boundary",
                null_boundary,
                default="0")
            private$..alpha <- jmvcore::OptionNumber$new(
                "alpha",
                alpha,
                default=0.05)
            private$..null_color <- jmvcore::OptionList$new(
                "null_color",
                null_color,
                default="#A40122",
                options=list(
                    "black",
                    "#00C2F9",
                    "#008DF9",
                    "#009F81",
                    "#FF5AAF",
                    "#9F0162",
                    "#A40122",
                    "#00FCCF",
                    "#FF6E3A",
                    "#FFB2FD",
                    "#8400CD",
                    "#E20134",
                    "#FFC33B",
                    "white",
                    "NA",
                    "NA",
                    "gray0",
                    "gray5",
                    "gray10",
                    "gray15",
                    "gray20",
                    "gray25",
                    "gray30",
                    "gray35",
                    "gray40",
                    "gray45",
                    "gray50",
                    "gray55",
                    "gray60",
                    "gray65",
                    "gray70",
                    "gray75",
                    "gray80",
                    "gray85",
                    "gray90",
                    "gray95",
                    "gray100"))
            private$..es_plot_width <- jmvcore::OptionString$new(
                "es_plot_width",
                es_plot_width,
                default="300")
            private$..es_plot_height <- jmvcore::OptionString$new(
                "es_plot_height",
                es_plot_height,
                default="400")
            private$..ymin <- jmvcore::OptionString$new(
                "ymin",
                ymin,
                default="auto")
            private$..ymax <- jmvcore::OptionString$new(
                "ymax",
                ymax,
                default="auto")
            private$..breaks <- jmvcore::OptionString$new(
                "breaks",
                breaks,
                default="auto")
            private$..ylab <- jmvcore::OptionString$new(
                "ylab",
                ylab,
                default="auto")
            private$..xlab <- jmvcore::OptionString$new(
                "xlab",
                xlab,
                default="auto")
            private$..axis.text.y <- jmvcore::OptionString$new(
                "axis.text.y",
                axis.text.y,
                default="14")
            private$..axis.title.y <- jmvcore::OptionString$new(
                "axis.title.y",
                axis.title.y,
                default="15")
            private$..axis.text.x <- jmvcore::OptionString$new(
                "axis.text.x",
                axis.text.x,
                default="14")
            private$..axis.title.x <- jmvcore::OptionString$new(
                "axis.title.x",
                axis.title.x,
                default="15")
            private$..error_layout <- jmvcore::OptionList$new(
                "error_layout",
                error_layout,
                default="halfeye",
                options=list(
                    "halfeye",
                    "eye",
                    "none"))
            private$..error_scale <- jmvcore::OptionString$new(
                "error_scale",
                error_scale,
                default="0.20")
            private$..error_nudge <- jmvcore::OptionString$new(
                "error_nudge",
                error_nudge,
                default="0.3")
            private$..data_layout <- jmvcore::OptionList$new(
                "data_layout",
                data_layout,
                default="random",
                options=list(
                    "random",
                    "swarm",
                    "none"))
            private$..data_spread <- jmvcore::OptionString$new(
                "data_spread",
                data_spread,
                default="0.25")
            private$..shape_raw <- jmvcore::OptionList$new(
                "shape_raw",
                shape_raw,
                default="circle filled",
                options=list(
                    "circle filled",
                    "square filled",
                    "triangle filled",
                    "diamond filled"))
            private$..shape_summary <- jmvcore::OptionList$new(
                "shape_summary",
                shape_summary,
                default="circle filled",
                options=list(
                    "circle filled",
                    "square filled",
                    "triangle filled",
                    "diamond filled"))
            private$..color_raw <- jmvcore::OptionList$new(
                "color_raw",
                color_raw,
                default="#008DF9",
                options=list(
                    "black",
                    "#00C2F9",
                    "#008DF9",
                    "#009F81",
                    "#FF5AAF",
                    "#9F0162",
                    "#A40122",
                    "#00FCCF",
                    "#FF6E3A",
                    "#FFB2FD",
                    "#8400CD",
                    "#E20134",
                    "#FFC33B",
                    "white",
                    "NA",
                    "NA",
                    "gray0",
                    "gray5",
                    "gray10",
                    "gray15",
                    "gray20",
                    "gray25",
                    "gray30",
                    "gray35",
                    "gray40",
                    "gray45",
                    "gray50",
                    "gray55",
                    "gray60",
                    "gray65",
                    "gray70",
                    "gray75",
                    "gray80",
                    "gray85",
                    "gray90",
                    "gray95",
                    "gray100"))
            private$..color_summary <- jmvcore::OptionList$new(
                "color_summary",
                color_summary,
                default="#008DF9",
                options=list(
                    "black",
                    "#00C2F9",
                    "#008DF9",
                    "#009F81",
                    "#FF5AAF",
                    "#9F0162",
                    "#A40122",
                    "#00FCCF",
                    "#FF6E3A",
                    "#FFB2FD",
                    "#8400CD",
                    "#E20134",
                    "#FFC33B",
                    "white",
                    "NA",
                    "NA",
                    "gray0",
                    "gray5",
                    "gray10",
                    "gray15",
                    "gray20",
                    "gray25",
                    "gray30",
                    "gray35",
                    "gray40",
                    "gray45",
                    "gray50",
                    "gray55",
                    "gray60",
                    "gray65",
                    "gray70",
                    "gray75",
                    "gray80",
                    "gray85",
                    "gray90",
                    "gray95",
                    "gray100"))
            private$..fill_raw <- jmvcore::OptionList$new(
                "fill_raw",
                fill_raw,
                default="NA",
                options=list(
                    "black",
                    "#00C2F9",
                    "#008DF9",
                    "#009F81",
                    "#FF5AAF",
                    "#9F0162",
                    "#A40122",
                    "#00FCCF",
                    "#FF6E3A",
                    "#FFB2FD",
                    "#8400CD",
                    "#E20134",
                    "#FFC33B",
                    "white",
                    "NA",
                    "NA",
                    "gray0",
                    "gray5",
                    "gray10",
                    "gray15",
                    "gray20",
                    "gray25",
                    "gray30",
                    "gray35",
                    "gray40",
                    "gray45",
                    "gray50",
                    "gray55",
                    "gray60",
                    "gray65",
                    "gray70",
                    "gray75",
                    "gray80",
                    "gray85",
                    "gray90",
                    "gray95",
                    "gray100"))
            private$..fill_summary <- jmvcore::OptionList$new(
                "fill_summary",
                fill_summary,
                default="#008DF9",
                options=list(
                    "black",
                    "#00C2F9",
                    "#008DF9",
                    "#009F81",
                    "#FF5AAF",
                    "#9F0162",
                    "#A40122",
                    "#00FCCF",
                    "#FF6E3A",
                    "#FFB2FD",
                    "#8400CD",
                    "#E20134",
                    "#FFC33B",
                    "white",
                    "NA",
                    "NA",
                    "gray0",
                    "gray5",
                    "gray10",
                    "gray15",
                    "gray20",
                    "gray25",
                    "gray30",
                    "gray35",
                    "gray40",
                    "gray45",
                    "gray50",
                    "gray55",
                    "gray60",
                    "gray65",
                    "gray70",
                    "gray75",
                    "gray80",
                    "gray85",
                    "gray90",
                    "gray95",
                    "gray100"))
            private$..size_raw <- jmvcore::OptionList$new(
                "size_raw",
                size_raw,
                default="2",
                options=list(
                    "1",
                    "2",
                    "3",
                    "4",
                    "5",
                    "6"))
            private$..size_summary <- jmvcore::OptionList$new(
                "size_summary",
                size_summary,
                default="4",
                options=list(
                    "1",
                    "2",
                    "3",
                    "4",
                    "5",
                    "6"))
            private$..alpha_raw <- jmvcore::OptionList$new(
                "alpha_raw",
                alpha_raw,
                default="1",
                options=list(
                    "1",
                    ".75",
                    ".5",
                    ".25",
                    ".20",
                    ".15",
                    ".10",
                    ".05",
                    "0"))
            private$..alpha_summary <- jmvcore::OptionList$new(
                "alpha_summary",
                alpha_summary,
                default="1",
                options=list(
                    "1",
                    ".75",
                    ".5",
                    ".25",
                    ".20",
                    ".15",
                    ".10",
                    ".05",
                    "0"))
            private$..linetype_summary <- jmvcore::OptionList$new(
                "linetype_summary",
                linetype_summary,
                default="solid",
                options=list(
                    "solid",
                    "dotted",
                    "dotdash",
                    "dashed",
                    "blank"))
            private$..color_interval <- jmvcore::OptionList$new(
                "color_interval",
                color_interval,
                default="black",
                options=list(
                    "black",
                    "#00C2F9",
                    "#008DF9",
                    "#009F81",
                    "#FF5AAF",
                    "#9F0162",
                    "#A40122",
                    "#00FCCF",
                    "#FF6E3A",
                    "#FFB2FD",
                    "#8400CD",
                    "#E20134",
                    "#FFC33B",
                    "white",
                    "NA",
                    "NA",
                    "gray0",
                    "gray5",
                    "gray10",
                    "gray15",
                    "gray20",
                    "gray25",
                    "gray30",
                    "gray35",
                    "gray40",
                    "gray45",
                    "gray50",
                    "gray55",
                    "gray60",
                    "gray65",
                    "gray70",
                    "gray75",
                    "gray80",
                    "gray85",
                    "gray90",
                    "gray95",
                    "gray100"))
            private$..size_interval <- jmvcore::OptionList$new(
                "size_interval",
                size_interval,
                default="3",
                options=list(
                    "1",
                    "2",
                    "3",
                    "4",
                    "5",
                    "6",
                    "7",
                    "8"))
            private$..alpha_interval <- jmvcore::OptionList$new(
                "alpha_interval",
                alpha_interval,
                default="1",
                options=list(
                    "1",
                    ".75",
                    ".5",
                    ".25",
                    ".20",
                    ".15",
                    ".10",
                    ".05",
                    "0"))
            private$..alpha_error <- jmvcore::OptionList$new(
                "alpha_error",
                alpha_error,
                default="1",
                options=list(
                    "1",
                    ".75",
                    ".5",
                    ".25",
                    ".20",
                    ".15",
                    ".10",
                    ".05",
                    "0"))
            private$..fill_error <- jmvcore::OptionList$new(
                "fill_error",
                fill_error,
                default="gray75",
                options=list(
                    "black",
                    "#00C2F9",
                    "#008DF9",
                    "#009F81",
                    "#FF5AAF",
                    "#9F0162",
                    "#A40122",
                    "#00FCCF",
                    "#FF6E3A",
                    "#FFB2FD",
                    "#8400CD",
                    "#E20134",
                    "#FFC33B",
                    "white",
                    "NA",
                    "NA",
                    "gray0",
                    "gray5",
                    "gray10",
                    "gray15",
                    "gray20",
                    "gray25",
                    "gray30",
                    "gray35",
                    "gray40",
                    "gray45",
                    "gray50",
                    "gray55",
                    "gray60",
                    "gray65",
                    "gray70",
                    "gray75",
                    "gray80",
                    "gray85",
                    "gray90",
                    "gray95",
                    "gray100"))

            self$.addOption(private$..switch)
            self$.addOption(private$..outcome_variable)
            self$.addOption(private$..mean)
            self$.addOption(private$..sd)
            self$.addOption(private$..n)
            self$.addOption(private$..outcome_variable_name)
            self$.addOption(private$..conf_level)
            self$.addOption(private$..effect_size)
            self$.addOption(private$..show_details)
            self$.addOption(private$..show_calculations)
            self$.addOption(private$..evaluate_hypotheses)
            self$.addOption(private$..null_value)
            self$.addOption(private$..null_boundary)
            self$.addOption(private$..alpha)
            self$.addOption(private$..null_color)
            self$.addOption(private$..es_plot_width)
            self$.addOption(private$..es_plot_height)
            self$.addOption(private$..ymin)
            self$.addOption(private$..ymax)
            self$.addOption(private$..breaks)
            self$.addOption(private$..ylab)
            self$.addOption(private$..xlab)
            self$.addOption(private$..axis.text.y)
            self$.addOption(private$..axis.title.y)
            self$.addOption(private$..axis.text.x)
            self$.addOption(private$..axis.title.x)
            self$.addOption(private$..error_layout)
            self$.addOption(private$..error_scale)
            self$.addOption(private$..error_nudge)
            self$.addOption(private$..data_layout)
            self$.addOption(private$..data_spread)
            self$.addOption(private$..shape_raw)
            self$.addOption(private$..shape_summary)
            self$.addOption(private$..color_raw)
            self$.addOption(private$..color_summary)
            self$.addOption(private$..fill_raw)
            self$.addOption(private$..fill_summary)
            self$.addOption(private$..size_raw)
            self$.addOption(private$..size_summary)
            self$.addOption(private$..alpha_raw)
            self$.addOption(private$..alpha_summary)
            self$.addOption(private$..linetype_summary)
            self$.addOption(private$..color_interval)
            self$.addOption(private$..size_interval)
            self$.addOption(private$..alpha_interval)
            self$.addOption(private$..alpha_error)
            self$.addOption(private$..fill_error)
        }),
    active = list(
        switch = function() private$..switch$value,
        outcome_variable = function() private$..outcome_variable$value,
        mean = function() private$..mean$value,
        sd = function() private$..sd$value,
        n = function() private$..n$value,
        outcome_variable_name = function() private$..outcome_variable_name$value,
        conf_level = function() private$..conf_level$value,
        effect_size = function() private$..effect_size$value,
        show_details = function() private$..show_details$value,
        show_calculations = function() private$..show_calculations$value,
        evaluate_hypotheses = function() private$..evaluate_hypotheses$value,
        null_value = function() private$..null_value$value,
        null_boundary = function() private$..null_boundary$value,
        alpha = function() private$..alpha$value,
        null_color = function() private$..null_color$value,
        es_plot_width = function() private$..es_plot_width$value,
        es_plot_height = function() private$..es_plot_height$value,
        ymin = function() private$..ymin$value,
        ymax = function() private$..ymax$value,
        breaks = function() private$..breaks$value,
        ylab = function() private$..ylab$value,
        xlab = function() private$..xlab$value,
        axis.text.y = function() private$..axis.text.y$value,
        axis.title.y = function() private$..axis.title.y$value,
        axis.text.x = function() private$..axis.text.x$value,
        axis.title.x = function() private$..axis.title.x$value,
        error_layout = function() private$..error_layout$value,
        error_scale = function() private$..error_scale$value,
        error_nudge = function() private$..error_nudge$value,
        data_layout = function() private$..data_layout$value,
        data_spread = function() private$..data_spread$value,
        shape_raw = function() private$..shape_raw$value,
        shape_summary = function() private$..shape_summary$value,
        color_raw = function() private$..color_raw$value,
        color_summary = function() private$..color_summary$value,
        fill_raw = function() private$..fill_raw$value,
        fill_summary = function() private$..fill_summary$value,
        size_raw = function() private$..size_raw$value,
        size_summary = function() private$..size_summary$value,
        alpha_raw = function() private$..alpha_raw$value,
        alpha_summary = function() private$..alpha_summary$value,
        linetype_summary = function() private$..linetype_summary$value,
        color_interval = function() private$..color_interval$value,
        size_interval = function() private$..size_interval$value,
        alpha_interval = function() private$..alpha_interval$value,
        alpha_error = function() private$..alpha_error$value,
        fill_error = function() private$..fill_error$value),
    private = list(
        ..switch = NA,
        ..outcome_variable = NA,
        ..mean = NA,
        ..sd = NA,
        ..n = NA,
        ..outcome_variable_name = NA,
        ..conf_level = NA,
        ..effect_size = NA,
        ..show_details = NA,
        ..show_calculations = NA,
        ..evaluate_hypotheses = NA,
        ..null_value = NA,
        ..null_boundary = NA,
        ..alpha = NA,
        ..null_color = NA,
        ..es_plot_width = NA,
        ..es_plot_height = NA,
        ..ymin = NA,
        ..ymax = NA,
        ..breaks = NA,
        ..ylab = NA,
        ..xlab = NA,
        ..axis.text.y = NA,
        ..axis.title.y = NA,
        ..axis.text.x = NA,
        ..axis.title.x = NA,
        ..error_layout = NA,
        ..error_scale = NA,
        ..error_nudge = NA,
        ..data_layout = NA,
        ..data_spread = NA,
        ..shape_raw = NA,
        ..shape_summary = NA,
        ..color_raw = NA,
        ..color_summary = NA,
        ..fill_raw = NA,
        ..fill_summary = NA,
        ..size_raw = NA,
        ..size_summary = NA,
        ..alpha_raw = NA,
        ..alpha_summary = NA,
        ..linetype_summary = NA,
        ..color_interval = NA,
        ..size_interval = NA,
        ..alpha_interval = NA,
        ..alpha_error = NA,
        ..fill_error = NA)
)

jamovimagnitudeResults <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "jamovimagnitudeResults",
    inherit = jmvcore::Group,
    active = list(
        debug = function() private$.items[["debug"]],
        help = function() private$.items[["help"]],
        overview = function() private$.items[["overview"]],
        es_smd = function() private$.items[["es_smd"]],
        point_null = function() private$.items[["point_null"]],
        interval_null = function() private$.items[["interval_null"]],
        magnitude_plot_warnings = function() private$.items[["magnitude_plot_warnings"]],
        magnitude_plot = function() private$.items[["magnitude_plot"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Means and Medians: Single Group")
            self$add(jmvcore::Preformatted$new(
                options=options,
                name="debug",
                visible=FALSE))
            self$add(jmvcore::Html$new(
                options=options,
                name="help",
                visible=FALSE))
            self$add(jmvcore::Table$new(
                options=options,
                name="overview",
                title="Overview",
                rows="(outcome_variable)",
                clearWith=list(
                    "outcome_variable",
                    "mean",
                    "sd",
                    "n",
                    "outcome_variable_name",
                    "conf_level",
                    "effect_size",
                    "show_details",
                    "show_calculations"),
                columns=list(
                    list(
                        `name`="outcome_variable_name", 
                        `title`="Outcome variable", 
                        `type`="text", 
                        `combineBelow`=TRUE),
                    list(
                        `name`="mean", 
                        `type`="number", 
                        `title`="<i>M</i>"),
                    list(
                        `name`="mean_LL", 
                        `title`="LL", 
                        `type`="number", 
                        `visible`="(effect_size == 'mean' | switch == 'from_summary')"),
                    list(
                        `name`="mean_UL", 
                        `title`="UL", 
                        `type`="number", 
                        `visible`="(effect_size == 'mean' | switch == 'from_summary')"),
                    list(
                        `name`="moe", 
                        `type`="number", 
                        `title`="<i>MoE</i>", 
                        `visible`="(show_details & effect_size == 'mean')"),
                    list(
                        `name`="mean_SE", 
                        `title`="<i>SE</i><sub>Mean</sub>", 
                        `type`="number", 
                        `visible`="(show_details & effect_size == 'mean')"),
                    list(
                        `name`="median", 
                        `title`="<i>Mdn</i>", 
                        `type`="number", 
                        `visible`="(switch == 'from_raw')"),
                    list(
                        `name`="median_LL", 
                        `title`="LL", 
                        `type`="number", 
                        `visible`="(effect_size == 'median' & switch == 'from_raw')"),
                    list(
                        `name`="median_UL", 
                        `title`="UL", 
                        `type`="number", 
                        `visible`="(effect_size == 'median' & switch == 'from_raw')"),
                    list(
                        `name`="median_SE", 
                        `type`="number", 
                        `title`="<i>SE</i><sub>Median</sub>", 
                        `visible`="(show_details & effect_size == 'median' & switch == 'from_raw')"),
                    list(
                        `name`="sd", 
                        `type`="number", 
                        `title`="<i>s</i>"),
                    list(
                        `name`="min", 
                        `title`="Minimum", 
                        `type`="number", 
                        `visible`="(switch == 'from_raw' & show_details)"),
                    list(
                        `name`="max", 
                        `title`="Maximum", 
                        `type`="number", 
                        `visible`="(switch == 'from_raw' & show_details)"),
                    list(
                        `name`="q1", 
                        `title`="25th", 
                        `type`="number", 
                        `superTitle`="Percentile", 
                        `visible`="(switch == 'from_raw' & show_details)"),
                    list(
                        `name`="q3", 
                        `title`="75th", 
                        `type`="number", 
                        `superTitle`="Percentile", 
                        `visible`="(switch == 'from_raw' & show_details)"),
                    list(
                        `name`="n", 
                        `title`="<i>N</i>", 
                        `type`="integer"),
                    list(
                        `name`="missing", 
                        `type`="integer", 
                        `title`="Missing", 
                        `visible`="(switch == 'from_raw')"),
                    list(
                        `name`="df_i", 
                        `title`="<i>df</i>", 
                        `type`="integer", 
                        `visible`="(show_details & effect_size == 'mean')"),
                    list(
                        `name`="t_multiplier", 
                        `type`="number", 
                        `title`="<i>t</i>", 
                        `superTitle`="Calculation component", 
                        `visible`="(show_calculations & effect_size == 'mean')"),
                    list(
                        `name`="s_component", 
                        `type`="number", 
                        `title`="Variability", 
                        `superTitle`="Calculation component", 
                        `visible`="(show_calculations & effect_size == 'mean')"),
                    list(
                        `name`="n_component", 
                        `type`="number", 
                        `title`="Sample size", 
                        `superTitle`="Calculation component", 
                        `visible`="(show_calculations & effect_size == 'mean')"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="es_smd",
                title="Standardized Mean Difference",
                rows="(outcome_variable)",
                visible="(effect_size == 'mean' & evaluate_hypotheses)",
                clearWith=list(
                    "outcome_variable",
                    "mean",
                    "sd",
                    "n",
                    "outcome_variable_name",
                    "conf_level",
                    "effect_size",
                    "show_details",
                    "show_calculations"),
                columns=list(
                    list(
                        `name`="outcome_variable_name", 
                        `title`="Outcome variable", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`=FALSE),
                    list(
                        `name`="effect", 
                        `title`="Effect", 
                        `type`="text"),
                    list(
                        `name`="mean", 
                        `title`="<i>M</i>", 
                        `type`="number"),
                    list(
                        `name`="reference_value", 
                        `title`="Reference value", 
                        `type`="number"),
                    list(
                        `name`="numerator", 
                        `title`="<i>M</i> &ndash; Reference", 
                        `superTitle`="Numerator", 
                        `type`="number"),
                    list(
                        `name`="denominator", 
                        `title`="Standardizer", 
                        `superTitle`="Standardizer", 
                        `type`="number"),
                    list(
                        `name`="effect_size", 
                        `type`="number", 
                        `title`="<i>d</i>"),
                    list(
                        `name`="LL", 
                        `title`="LL", 
                        `type`="number"),
                    list(
                        `name`="UL", 
                        `title`="UL", 
                        `type`="number"),
                    list(
                        `name`="SE", 
                        `title`="<i>SE</i>", 
                        `type`="number", 
                        `visible`="(show_details)"),
                    list(
                        `name`="df", 
                        `title`="<i>df</i>", 
                        `type`="integer", 
                        `visible`="(show_details)"),
                    list(
                        `name`="d_biased", 
                        `title`="<i>d</i><sub>biased</sub>", 
                        `type`="number"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="point_null",
                title="Hypothesis Evaluation",
                rows=1,
                visible="(evaluate_hypotheses & null_boundary == 0)",
                clearWith=list(
                    "outcome_variable",
                    "mean",
                    "sd",
                    "n",
                    "outcome_variable_name",
                    "conf_level",
                    "effect_size",
                    "show_details",
                    "show_calculations",
                    "null_value",
                    "null_boundary"),
                columns=list(
                    list(
                        `name`="effect", 
                        `title`="Effect", 
                        `type`="text", 
                        `combineBelow`=FALSE),
                    list(
                        `name`="null_words", 
                        `title`="<i>H</i><sub>0</sub>", 
                        `type`="text"),
                    list(
                        `name`="CI", 
                        `title`="CI", 
                        `type`="text"),
                    list(
                        `name`="CI_compare", 
                        `title`="Compare CI with <i>H</i><sub>0</sub>", 
                        `type`="text"),
                    list(
                        `name`="t", 
                        `title`="<i>t</i>", 
                        `type`="number", 
                        `visible`="(effect_size == 'mean')"),
                    list(
                        `name`="df", 
                        `title`="<i>df</i>", 
                        `type`="integer", 
                        `visible`="(effect_size == 'mean')"),
                    list(
                        `name`="p", 
                        `title`="<i>p</i>, two tailed", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(effect_size == 'mean')"),
                    list(
                        `name`="p_result", 
                        `title`="<i>p</i>, two-tailed", 
                        `type`="text", 
                        `visible`="(effect_size == 'median')"),
                    list(
                        `name`="null_decision", 
                        `title`="<i>H</i><sub>0</sub> decision"),
                    list(
                        `name`="conclusion", 
                        `title`="Conclusion", 
                        `type`="text"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="interval_null",
                title="Hypothesis Evaluation",
                rows=1,
                visible="(evaluate_hypotheses & null_boundary != 0)",
                clearWith=list(
                    "outcome_variable",
                    "mean",
                    "sd",
                    "n",
                    "outcome_variable_name",
                    "conf_level",
                    "effect_size",
                    "show_details",
                    "show_calculations",
                    "null_value",
                    "null_boundary"),
                columns=list(
                    list(
                        `name`="effect", 
                        `title`="Effect", 
                        `type`="text", 
                        `combineBelow`=FALSE),
                    list(
                        `name`="rope", 
                        `title`="<i>H</i><sub>0</sub>", 
                        `type`="text"),
                    list(
                        `name`="CI", 
                        `title`="CI", 
                        `type`="text"),
                    list(
                        `name`="rope_compare", 
                        `title`="Compare CI with <i>H</i><sub>0</sub>", 
                        `type`="text"),
                    list(
                        `name`="p_result", 
                        `title`="<i>p</i>, two tailed", 
                        `type`="text"),
                    list(
                        `name`="conclusion", 
                        `title`="Conclusion", 
                        `type`="text"))))
            self$add(jmvcore::Html$new(
                options=options,
                name="magnitude_plot_warnings",
                title="Figure Warnings",
                visible=TRUE))
            self$add(jmvcore::Image$new(
                options=options,
                name="magnitude_plot",
                title="Estimation Figure",
                requiresData=TRUE,
                width=400,
                height=300,
                renderFun=".magnitude_plot",
                refs="ggdist"))}))

jamovimagnitudeBase <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "jamovimagnitudeBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = "esci",
                name = "jamovimagnitude",
                version = c(1,0,0),
                options = options,
                results = jamovimagnitudeResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE,
                requiresMissings = FALSE,
                weightsSupport = 'auto')
        }))

#' Means and Medians: Single Group
#'
#' 
#' @param switch .
#' @param data .
#' @param outcome_variable .
#' @param mean .
#' @param sd .
#' @param n .
#' @param outcome_variable_name .
#' @param conf_level .
#' @param effect_size .
#' @param show_details .
#' @param show_calculations .
#' @param evaluate_hypotheses .
#' @param null_value .
#' @param null_boundary .
#' @param alpha .
#' @param null_color .
#' @param es_plot_width .
#' @param es_plot_height .
#' @param ymin .
#' @param ymax .
#' @param breaks .
#' @param ylab .
#' @param xlab .
#' @param axis.text.y .
#' @param axis.title.y .
#' @param axis.text.x .
#' @param axis.title.x .
#' @param error_layout .
#' @param error_scale .
#' @param error_nudge .
#' @param data_layout .
#' @param data_spread .
#' @param shape_raw .
#' @param shape_summary .
#' @param color_raw .
#' @param color_summary .
#' @param fill_raw .
#' @param fill_summary .
#' @param size_raw .
#' @param size_summary .
#' @param alpha_raw .
#' @param alpha_summary .
#' @param linetype_summary .
#' @param color_interval .
#' @param size_interval .
#' @param alpha_interval .
#' @param alpha_error .
#' @param fill_error .
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$debug} \tab \tab \tab \tab \tab a preformatted \cr
#'   \code{results$help} \tab \tab \tab \tab \tab a html \cr
#'   \code{results$overview} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$es_smd} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$point_null} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$interval_null} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$magnitude_plot_warnings} \tab \tab \tab \tab \tab a html \cr
#'   \code{results$magnitude_plot} \tab \tab \tab \tab \tab an image \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$overview$asDF}
#'
#' \code{as.data.frame(results$overview)}
#'
#' @export
jamovimagnitude <- function(
    switch = "from_raw",
    data,
    outcome_variable,
    mean = "",
    sd = "",
    n = "",
    outcome_variable_name = "Outcome variable",
    conf_level = 95,
    effect_size = "mean",
    show_details = FALSE,
    show_calculations = FALSE,
    evaluate_hypotheses = FALSE,
    null_value = "0",
    null_boundary = "0",
    alpha = 0.05,
    null_color = "#A40122",
    es_plot_width = "300",
    es_plot_height = "400",
    ymin = "auto",
    ymax = "auto",
    breaks = "auto",
    ylab = "auto",
    xlab = "auto",
    axis.text.y = "14",
    axis.title.y = "15",
    axis.text.x = "14",
    axis.title.x = "15",
    error_layout = "halfeye",
    error_scale = "0.20",
    error_nudge = "0.3",
    data_layout = "random",
    data_spread = "0.25",
    shape_raw = "circle filled",
    shape_summary = "circle filled",
    color_raw = "#008DF9",
    color_summary = "#008DF9",
    fill_raw = "NA",
    fill_summary = "#008DF9",
    size_raw = "2",
    size_summary = "4",
    alpha_raw = "1",
    alpha_summary = "1",
    linetype_summary = "solid",
    color_interval = "black",
    size_interval = "3",
    alpha_interval = "1",
    alpha_error = "1",
    fill_error = "gray75") {

    if ( ! requireNamespace("jmvcore", quietly=TRUE))
        stop("jamovimagnitude requires jmvcore to be installed (restart may be required)")

    if ( ! missing(outcome_variable)) outcome_variable <- jmvcore::resolveQuo(jmvcore::enquo(outcome_variable))
    if (missing(data))
        data <- jmvcore::marshalData(
            parent.frame(),
            `if`( ! missing(outcome_variable), outcome_variable, NULL))


    options <- jamovimagnitudeOptions$new(
        switch = switch,
        outcome_variable = outcome_variable,
        mean = mean,
        sd = sd,
        n = n,
        outcome_variable_name = outcome_variable_name,
        conf_level = conf_level,
        effect_size = effect_size,
        show_details = show_details,
        show_calculations = show_calculations,
        evaluate_hypotheses = evaluate_hypotheses,
        null_value = null_value,
        null_boundary = null_boundary,
        alpha = alpha,
        null_color = null_color,
        es_plot_width = es_plot_width,
        es_plot_height = es_plot_height,
        ymin = ymin,
        ymax = ymax,
        breaks = breaks,
        ylab = ylab,
        xlab = xlab,
        axis.text.y = axis.text.y,
        axis.title.y = axis.title.y,
        axis.text.x = axis.text.x,
        axis.title.x = axis.title.x,
        error_layout = error_layout,
        error_scale = error_scale,
        error_nudge = error_nudge,
        data_layout = data_layout,
        data_spread = data_spread,
        shape_raw = shape_raw,
        shape_summary = shape_summary,
        color_raw = color_raw,
        color_summary = color_summary,
        fill_raw = fill_raw,
        fill_summary = fill_summary,
        size_raw = size_raw,
        size_summary = size_summary,
        alpha_raw = alpha_raw,
        alpha_summary = alpha_summary,
        linetype_summary = linetype_summary,
        color_interval = color_interval,
        size_interval = size_interval,
        alpha_interval = alpha_interval,
        alpha_error = alpha_error,
        fill_error = fill_error)

    analysis <- jamovimagnitudeClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}

