% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_getevent.R
\name{aux_getevent}
\alias{aux_getevent}
\title{Load seismic data of a user-defined event}
\usage{
aux_getevent(start, duration, station, component = "BHZ", format = "sac",
  dir, simplify = TRUE, eseis = TRUE)
}
\arguments{
\item{start}{\code{POSIXct} value, start time of the data to import.}

\item{duration}{\code{Numeric} value, duration of the data to import,
in seconds.}

\item{station}{\code{Character} value, seismic station ID, which must
correspond to the ID in the file name of the data directory structure 
(cf. \code{aux_organisecubefiles}).}

\item{component}{\code{Character} value, seismic component, which must
correspond to the component name in the file name of the data directory  
structure (cf. \code{aux_organisecubefiles}). Default is 
\code{"BHZ"} (vertical component of a sac file).}

\item{format}{\code{Character} value, seismic data format. One out of 
\code{"sac"} and \code{"mseed"}. Default is \code{"sac"}.}

\item{dir}{\code{Character} value, path to the seismic data directory.}

\item{simplify}{\code{Logical} value, option to simplify output
when possible. This basically means that if only data from one station 
is loaded, the list object will have one level less. Default is 
\code{TRUE}.}

\item{eseis}{\code{Logical} value, option to read data to an \code{eseis}
object (recommended, see documentation of 
\code{aux_initiateeseis}), default is \code{TRUE}}
}
\value{
A \code{list} object containing either a set of \code{eseis}
objects or a data set with the time vector (\code{$time}) 
and a list of seismic stations (\code{$station_ID}) with their seismic
signals as data frame (\code{$signal}). If \code{simplify = TRUE} (the 
default option) and only one seismic station is provided, the output  
object containseither just one eseis object or the vectors for 
\code{$time} and \code{$signal}.
}
\description{
The function loads seismic data from a data directory structure (see 
\code{aux_organisecubefiles()}) based on the event start time, duration,
component and station ID.
}
\details{
The function assumes complete data sets, i.e., not a single hourly 
data set must be missing. The time 
vector is loaded only once, from the first station and its first 
component. Thus, it is assumed that all loaded seismic signals are
of the same sampling frequency and length.
}
\examples{

## set seismic data directory
dir_data <- paste0(system.file("extdata", package="eseis"), "/")

## load the z component data from a station
data <- aux_getevent(start = as.POSIXct(x = "2017-04-09 01:20:00", 
                                        tz = "UTC"), 
                      duration = 120,
                      station = "RUEG1",
                      component = "BHZ",
                      dir = dir_data)                       
## plot signal
plot_signal(data = data)

## load data from two stations
data <- aux_getevent(start = as.POSIXct(x = "2017-04-09 01:20:00", 
                                        tz = "UTC"), 
                     duration = 120,
                     station = c("RUEG1", "RUEG2"),
                     component = "BHZ",
                     dir = dir_data)

## simplify data structure
data <- lapply(X = data, FUN = function(data) {data[[1]]})

## plot both signals
par(mfcol = c(2, 1))
lapply(X = data, FUN = plot_signal)
                     
}
\author{
Michael Dietze
}
\keyword{eseis}
