% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_taper.R
\name{signal_taper}
\alias{signal_taper}
\title{Taper a signal vector.}
\usage{
signal_taper(data, p = 0, n)
}
\arguments{
\item{data}{\code{eseis} object, \code{numeric} vector or list of 
objects, data set to be processed.}

\item{p}{\code{Numeric} value, proportion of the signal vector to be 
tapered. Alternative to \code{n}.}

\item{n}{\code{Numeric} value, number of samples to be tapered at each
end of the signal vector.}
}
\value{
\code{Data frame}, tapered signal vector.
}
\description{
The function tapers a signal vector with a cosine bell taper, either of a
given proportion or a discrete number of samples.
}
\examples{

## load example data set
data(rockfall)

## remove mean from data set
rockfall <- signal_demean(data = rockfall_eseis)

## create artefact at the beginning
rockfall_eseis$signal[1:100] <- runif(n = 100, min = -5000, max = 5000)

## taper signal
rockfall_taper <- signal_taper(data = rockfall, n = 1000)

## plot both data sets
plot_signal(data = rockfall_eseis)
plot_signal(rockfall_taper)
                     
}
\author{
Michael Dietze
}
\keyword{eseis}
