% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmi_parameters.R
\name{fmi_parameters}
\alias{fmi_parameters}
\title{Create reference model reference parameter catalogue}
\usage{
fmi_parameters(
  n,
  d_s,
  s_s,
  r_s,
  q_s,
  h_w,
  w_w,
  a_w,
  f_min,
  f_max,
  r_0,
  f_0,
  q_0,
  v_0,
  p_0,
  e_0,
  n_0_a,
  n_0_b,
  res
)
}
\arguments{
\item{n}{\code{Numeric} value, number of output reference spectra.}

\item{d_s}{\code{Numeric} value, mean sediment grain diameter (m). 
Alternative to \code{gsd}.}

\item{s_s}{\code{Numeric} value, standard deviation of sediment grain 
diameter (m). Alternative to \code{gsd}.}

\item{r_s}{\code{Numeric} value, specific sediment density (kg / m^3)}

\item{q_s}{\code{Numeric} value, unit sediment flux (m^2 / s)}

\item{h_w}{\code{Numeric} value, fluid flow depth (m)}

\item{w_w}{\code{Numeric} value, fluid flow width (m)}

\item{a_w}{\code{Numeric} value, fluid flow inclination angle (radians)}

\item{f_min}{\code{Numeric} value, lower boundary of the frequency range 
to be modelled.}

\item{f_max}{\code{Numeric} value, upper boundary of the frequency range 
to be modelled.}

\item{r_0}{\code{Numeric} value, distance of seismic station to source}

\item{f_0}{\code{Numeric} value, reference frequency (Hz)}

\item{q_0}{\code{Numeric} value, ground quality factor at \code{f_0}.
"Reasonable value may be \code{20}" (Tsai et al. 2012).}

\item{v_0}{\code{Numeric} value, phase speed of the Rayleigh wave at 
\code{f_0} (m/s). Assuming a shear wave velocity of about 2200 m/s, 
Tsai et al. (2012) yield a value of 1295 m/s for this parameter.}

\item{p_0}{\code{Numeric} value, variation exponent of Rayleigh wave 
velocities with frequency (dimensionless)}

\item{e_0}{\code{Numeric} value, exponent characterizing quality factor 
increase with frequency (dimensionless). "Reasonable value may be 
\code{0}" (Tsai et al. 2012).}

\item{n_0_a}{\code{Numeric} value, lower Greens function 
displacement amplitude coefficients. Cf. N_ij in eq. 36 in Gimbert et 
al. (2014)}

\item{n_0_b}{\code{Numeric} value, lower Greens function 
displacement amplitude coefficients. Cf. N_ij in eq. 36 in Gimbert et 
al. (2014)}

\item{res}{\code{Numeric} value, output resolution, i.e. length of the 
spectrum vector.}
}
\value{
\code{List} object with model reference parameters.
}
\description{
In order to run the fluvial model inversion (FMI) routine, a set of 
randomised target parameter combinations needs to be created. This 
function does this job.
}
\details{
All parameters must be provided as single values, except for those 
parameters that shall be randomised, which must be provided as a vector
of length two. This vector defines the range within which uniformly 
distributed random values will be generated and assigned.
}
\examples{

## create two parameter sets where h_w (water level) and q_s (sediment
## flux) are randomly varied.

ref_pars <- fmi_parameters(n = 2,
                           h_w = c(0.02, 2.00),
                           q_s = c(0.001, 50.000) / 2650,
                           d_s = 0.01,
                           s_s = 1.35,
                           r_s = 2650,
                           w_w = 6,
                           a_w = 0.0075,
                           f_min = 5,
                           f_max = 80,
                           r_0 = 6,
                           f_0 = 1,
                           q_0 = 10,
                           v_0 = 350,
                           p_0 = 0.55,
                           e_0 = 0.09,
                           n_0_a = 0.6,
                           n_0_b = 0.8,
                           res = 100)

}
\author{
Michael Dietze
}
\keyword{eseis}
