% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick_correlation.R
\name{pick_correlation}
\alias{pick_correlation}
\title{Signal correlation based event picking}
\usage{
pick_correlation(data, on, template, dur_min, time, dt)
}
\arguments{
\item{data}{\code{eseis} object, \code{numeric} vector or list of 
objects, data set to be processed.}

\item{on}{\code{Numeric} value, minimum correlation coefficient to define 
event occurence.}

\item{template}{\code{eseis} object or signal vector, template event 
with which the data set is correlated.}

\item{dur_min}{\code{Numeric} value, minimum duration of the event. This 
is required as the routine tends to identify multipe picks with similarly 
high correlation coefficients due to autocorrelation effects. If omitted, 
\code{dur_min} is set to \code{0}, i.e., all picks are returned.}

\item{time}{\code{POSIXct} vector, time vector of the signal(s). If not 
provided, a synthetic time vector will be created.}

\item{dt}{\code{Numeric} value, sampling period. If omitted, either 
estimated from \code{time} or set to 0.01 s (i.e., f = 100 Hz).}
}
\value{
\code{data.frame}, picked events.
}
\description{
The function picks (identifies) events from continuous data by comparing 
the data patterns against a template signal using Pearson's correlation 
coefficient, defining an event when that coefficient is above a threshold 
value.
}
\examples{

## create synthetic event signal
p <- sin(seq(0, 10 * pi, by = 0.35)) * 0.2 * 
  (1 + sin(seq(0, pi, length.out = 90)))^5

## show event signal
plot(p, type = "l")

## create synthetic noise signal
x <- runif(n = 1000, min = -1, max = 1)
t <- seq(from = Sys.time(), length.out = length(x), by = 1/200)
ii <- floor(runif(n = 3, min = 100, max = 900))

## add events to noise
for(k in 1:length(ii)) {
  
  nn <- ii[k]:(ii[k] + 89)
  x[nn] <- x[nn] + p
}

## show resulting time series
plot(x = t, y = x, type = "l")

## pick events based on template
picks <- eseis::pick_correlation(data = x, 
                                 on = 0.8, 
                                 template = p, 
                                 time = t, 
                                 dt = 1/200)
                                 
## show result
print(picks)
                     
}
\author{
Michael Dietze
}
\keyword{eseis}
