% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_spectrum.R
\name{signal_spectrum}
\alias{signal_spectrum}
\title{Calculate the spectrum of a time series}
\usage{
signal_spectrum(data, dt, method = "periodogram", n, ...)
}
\arguments{
\item{data}{\code{eseis} object, \code{numeric} vector or list of 
objects, data set to be processed.}

\item{dt}{\code{Numeric} value, sampling period. If omitted, \code{dt} 
is set to 1/200. Only needed if \code{data} is no \code{eseis} object.}

\item{method}{\code{Character} value, calculation method. One out of 
\code{"periodogram"} and \code{"autoregressive"}. 
default is \code{"periodogram"}.}

\item{n}{\code{Numeric} value, optional number of samples in 
running window used for smoothing the spectrogram. Only applied if a 
number is provided. Smoothing is performed as running mean.}

\item{\dots}{Additional arguments passed to the function.}
}
\value{
\code{Data frame} with frequency and power vector
}
\description{
The power spectral density estimate of the time series is calculated using 
different approaches.
}
\examples{

## load example data set
data(rockfall)

## calculate spectrum with standard setup
s <- signal_spectrum(data = rockfall_eseis)

## plot spectrum
plot_spectrum(data = s)

}
\author{
Michael Dietze
}
\keyword{eseis}
