% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setES.R
\name{setES}
\alias{setES}
\title{setES}
\usage{
setES(MAXPROMPT = NULL, IMEI_NUMBERS = NULL, SVYNAMES = NULL,
  ESVN = NULL)
}
\arguments{
\item{MAXPROMPT}{a numeric value. The number of prompts per day.}

\item{IMEI_NUMBERS}{a vector of character strings. Each element of the vector specifies an IMEI number of at least one of the phone that have been used in the ESM study.}

\item{SVYNAMES}{a vector of character strings. Each element of the vector specifies one ESM version, which must exist as a separate column in the raw ESM dataset(s). If in function \code{\link{relevantESVN}} the default value NULL has been kept for the argument svyName, also keep the default value NULL for this argument! Keeping the default value NULL is not recommended, though. See \strong{NOTE} in the description of the argument 'svyName' of function \code{\link{relevantESVN}}.}

\item{ESVN}{a list. Each element of the list must specify one of the relevant column names of the raw ESM dataset(s); i.e. the ESM survey version, the IMEI number, the start date, the start time, the end date, and the end time. Use function \code{\link{relevantESVN}} to generate \code{ESVN}.}
}
\value{
2 separate lists. Each element of the lists is named according to the variable's content. See \strong{Details} for more information.
}
\description{
setES sets the relevant variable names concerning the ESM dataset(s).
}
\details{
The one list is named RELEVANTINFO_ES. It contains 3 elements.
\enumerate{
\item MAXPROMPT: the number of daily prompts on the mobile device
\item IMEI_NUMBERS: all the IMEI numbers that are used in the study
\item SVYNAMES: the names of all ESM questionnaire versions used in the study.
}
The other list is named RELEVANTVN_ES, it contains either 4 or 6 elements, depending on whether the start date and the start time already exist as a date-time object (same for end date and end time). In the latter case the list elements' names are:
\enumerate{
\item ES_SVY_NAME: the column name in the ESM dataset(s) holding the name of the ESM questionnaire version
\item ES_IMEI: the column name in the ESM dataset(s) holding the IMEI number
\item ES_START_DATE: the date of when an ESM questionnaire was started
\item ES_START_TIME: the time of when an ESM questionnaire was started
\item ES_END_DATE: the date of when an ESM questionnaire was finished
\item ES_END_TIME: the time of when an ESM questionnaire was finished
}
If the start date and start time (same for end date and end time) are combined to a date-time object, the 3rd list element will be ES_STARTDATETIME and the 4th element will be ES_ENDDATETIME
The last element will always be ES_DATETIMES_SEP: TRUE if date and time are separated, FALSE if they are a single date-time object.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute setES. Start --------------------
relEs <- relevantESVN(svyName="survey_name", IMEI="IMEI",
STARTDATE="start_date", STARTTIME="start_time",
ENDDATE="end_date", ENDTIME="end_time")
# Prerequisites in order to execute setES. End ----------------------
# ------------------------------------------------------
# Run function 4 of 28; see esmprep functions' hierarchy.
# ------------------------------------------------------
# imeiNumbers is the vector containing all IMEI numbers used in
# the ESM study; use the respective entries in the referenceDf.
imeiNumbers <- as.character(referenceDf$imei)
# surveyNames is the vector containing all ESM version names.
surveyNames <- c(
# Test group
   "morningTestGroup", "dayTestGroup", "eveningTestGroup",
# Control group
   "morningControlGroup", "dayControlGroup", "eveningControlGroup")
# 4 is the number of daily prompts
# relEs is the result of function 'relevantESVN'
RELEVANT_ES <- setES(4, imeiNumbers, surveyNames, relEs)
# Extract relevant ESM general information
RELEVANTINFO_ES <- RELEVANT_ES[["RELEVANTINFO_ES"]]
# Extract list of relevant variables names of raw ESM datasets.
RELEVANTVN_ES <- RELEVANT_ES[["RELEVANTVN_ES"]]

# With date-time objects instead of separate date and time
relEs <- relevantESVN(svyName="survey_name", IMEI="IMEI",
START_DATETIME="start_dateTime", END_DATETIME="end_dateTime")
RELEVANT_ES <- setES(4, imeiNumbers, surveyNames, relEs)
# Extract relevant ESM general information
RELEVANTINFO_ES <- RELEVANT_ES[["RELEVANTINFO_ES"]]
# Extract list of relevant variables names of raw ESM datasets.
RELEVANTVN_ES <- RELEVANT_ES[["RELEVANTVN_ES"]]
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 4 of 28).
}
