% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histo_vol.R
\name{histo.vol}
\alias{histo.vol}
\title{Histogram of a volume
\loadmathjax}
\usage{
histo.vol(vol, breaks = NULL, alias = "", description = NULL)
}
\arguments{
\item{vol}{"volume" class object.}

\item{breaks}{Vector giving the breakpoints between histogram cells. If
\code{breaks = NULL},
the chosen breakpoints are those used by the \link[graphics]{hist} function
by default. If \code{breaks} are specified, outside values of \code{vol$vol3D.data}
are not taken into account.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the the created object. If the
\code{description = NULL} (default value), it will be set to \code{vol$description}.}
}
\value{
Returns a "histo" class object. This is a list including:
\itemize{
\item \code{$patient}: set to \code{vol$patient}.
\item \code{$patient.name}: set to \code{vol$patient.name}.
\item \code{$patient.bd}: set to \code{vol$patient.bd}.
\item \code{$patient.sex}: set to \code{vol$patient.sex}.
\item \code{$file.basename}: set to "".
\item \code{$file.dirname}: set to "".
\item \code{$object.name}: set to "".
\item \code{$object.alias}: alias of the histo object.
\item \code{$frame.of.reference}: set to \code{vol$frame.of.reference}.
\item \code{$ref.pseudo} : set to \code{vol$ref.pseudo}.
\item \code{$modality} : set to \code{"histo"}.
\item \code{$description}: description of the histo object.
\item \code{$creation.date}: set to \code{Sys.Date}.
\item \code{$nb.MC}: set to 0.
\item \code{$breaks}: vector breakpoints
\item \code{$mids}: vector of cell centers.
\item \code{$mids.unit}: Character string, representing the unit of the abcissa
of the histogram. For instance, "Gy", when \code{vol} is a rtdose.
\item \code{counts}: count of voxels whose value is included in the limits
defined by \code{$breaks}.
\item \code{dV_dx}: differential histogram, expressed in \mjeqn{cm^3}{ascii} by voxel units,
at each \code{$mids}.
}
}
\description{
The \code{histo.vol} function calculates the voxel values
histogram of "volume" class object.
}
\examples{
# loading of toy-patient objects
step <- 3
patient <- toy.load.patient (modality = "ct", dxyz = rep (step, 3))
CT <- patient$ct[[1]]

# histogram and display
H <- histo.vol (CT, breaks = seq (3, ceiling (CT$max.pixel), 1), 
                alias = "CT_hist")
str (H)
}
\seealso{
\link[espadon]{histo.from.roi}, \link[espadon]{histo.from.bin},
\link[espadon]{display.histo}, \link[espadon]{display.dV_dx}
}
