% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vol_subsampling.R
\name{vol.subsampling}
\alias{vol.subsampling}
\title{Subsampling a volume}
\usage{
vol.subsampling(
  vol,
  fact.ijk = 2,
  interpolate = TRUE,
  alias = "",
  description = NULL
)
}
\arguments{
\item{vol}{"volume" class object.}

\item{fact.ijk}{Strictly positive integer, or a vector of 3 strictly positive integers.}

\item{interpolate}{Boolean, default to \code{TRUE}. If \code{interpolate = TRUE}, a
trilinear interpolation of the value of the voxels, relative to the values of
adjacent voxels, is performed.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the the created object.
If \code{description = NULL}, it will be \code{paste ("subsampling" ,vol$description)}.}
}
\value{
Returns a "volume" class object, in which 3D volume grid is
subsampled: the voxel size is multiplied by \code{fact.ijk} and the center location
of the volume is invariant.
}
\description{
The \code{vol.subsampling} function sub-samples the grid of a "volume" class
object.
}
\examples{
vol <- vol.create(n.ijk = c(10,10,1),dxyz = c(2,2,2), ref.pseudo = "ref1", 
                  modality ="test", pt000 = c(0,0,0))
vol$vol3D.data[] <- array(1:prod(vol$n.ijk), dim = vol$n.ijk)
vol$max.pixel <- prod(vol$n.ijk)
vol$min.pixel <- 1
mid <- as.numeric (apply (get.extreme.pt (vol), 1, mean))
vol_ss <- vol.subsampling (vol, fact.ijk= 2)
mid_ss <- as.numeric (apply (get.extreme.pt (vol_ss), 1, mean))
display.plane(vol,interpolate = FALSE, view.coord = mid[3], 
              abs.rng = c(-5,25), ord.rng = c(-5,25), bg="green")
points (mid[1], mid[2], pch=16, col="red")
display.plane(vol_ss,interpolate = FALSE, view.coord = mid_ss[3], 
              abs.rng = c(-5,25), ord.rng = c(-5,25), bg="green")
points (mid_ss[1], mid_ss[2], pch=16, col="red")
}
\seealso{
\link[espadon]{vol.oversampling}.
}
