% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_intersection.R
\name{bin.intersection}
\alias{bin.intersection}
\title{Intersection of two binaries}
\usage{
bin.intersection(vol1, vol2, alias = "", description = NULL)
}
\arguments{
\item{vol1, vol2}{"volume" class objects, of "binary" modality.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the created object. If
\code{description = NULL} (default value), it will be set to
\code{paste (vol1$object.alias, "&", vol2$object.alias)}.}
}
\value{
Returns a "volume" class object of "binary" modality (see
\link[espadon]{espadon.class} for class definitions), with the same grid as
\code{vol1} and \code{vol2}, intersection of \code{vol1} and \code{vol2}.
}
\description{
The \code{bin.intersection} function creates a "volume"
class object, of "binary" modality, representing the intersection (logical
\code{AND}) of two binary objects.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 3
patient <- toy.load.patient (modality = c("mr", "rtstruct"), 
                             roi.name = c("brain", "labyrinth processing unit"), 
                             dxyz = rep (step, 3))
MR <- patient$mr[[1]]
S <- patient$rtstruct[[1]]

z.brain <- S$roi.info$Gz[S$roi.info$roi.pseudo == "brain"]

# Try to discriminate the processing unit with binary selections
bin.brain <- bin.from.roi (MR, struct = S, roi.name = "brain",
                           alias = "brain", T.MAT = patient$T.MAT)
bin.pu.density <- bin.from.vol (MR, min = 160)   
   
display.plane (MR, top = bin.pu.density, display.ref = S$ref.pseudo,
               view.coord = z.brain, T.MAT = patient$T.MAT, 
               interpolate = FALSE, main = "before brain intersection")                      
bin.pu <- bin.intersection (vol1 = bin.pu.density, vol2 = bin.brain, 
                            alias = "processing unit")
display.plane (MR, top = bin.pu, display.ref = S$ref.pseudo,
               view.coord = z.brain, T.MAT = patient$T.MAT, 
               interpolate = FALSE, main = "after brain intersection")
}
